/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.util.captcha;

import com.atlassian.stash.internal.web.util.captcha.Language;
import com.octo.captcha.component.word.wordgenerator.WordGenerator;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CensoringWordGenerator
implements WordGenerator {
    private static final Logger log = LoggerFactory.getLogger(CensoringWordGenerator.class);
    private final WordGenerator delegate;

    public CensoringWordGenerator(@Nonnull WordGenerator delegate) {
        this.delegate = Objects.requireNonNull(delegate, "delegate");
        log.debug("Using CensoringWordGenerator to censor {}", (Object)delegate.getClass().getName());
    }

    public String getWord(@Nonnull Integer length) {
        Objects.requireNonNull(length, "length");
        return this.getWord(length, Locale.getDefault());
    }

    public String getWord(@Nonnull Integer length, @Nonnull Locale locale) {
        Objects.requireNonNull(length, "length");
        Objects.requireNonNull(locale, "locale");
        Language language = Language.forLocale((Locale)locale);
        String word = this.delegate.getWord(length, locale);
        for (int i = 0; i < 100 && language.isOffensive(word); ++i) {
            word = this.delegate.getWord(length, locale);
        }
        return word;
    }
}

