/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.util;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.springframework.validation.Errors;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;

public class FilteredErrors
implements Errors {
    private final Errors delegate;
    private final Predicate<String> ignoreFieldPredicate;

    public FilteredErrors(Errors delegate, String ... ignoredFieldNames) {
        this(delegate, Predicates.in((Collection)Sets.newHashSet((Object[])ignoredFieldNames)));
    }

    public FilteredErrors(Errors delegate, Predicate<String> ignoreFieldPredicate) {
        this.delegate = delegate;
        this.ignoreFieldPredicate = ignoreFieldPredicate;
    }

    public String getObjectName() {
        return this.delegate.getObjectName();
    }

    public void setNestedPath(String nestedPath) {
        this.delegate.setNestedPath(nestedPath);
    }

    public String getNestedPath() {
        return this.delegate.getNestedPath();
    }

    public void pushNestedPath(String subPath) {
        this.delegate.pushNestedPath(subPath);
    }

    public void popNestedPath() throws IllegalStateException {
        this.delegate.popNestedPath();
    }

    public void reject(String errorCode) {
        this.delegate.reject(errorCode);
    }

    public void reject(String errorCode, String defaultMessage) {
        this.delegate.reject(errorCode, defaultMessage);
    }

    public void reject(String errorCode, Object[] errorArgs, String defaultMessage) {
        this.delegate.reject(errorCode, errorArgs, defaultMessage);
    }

    public void rejectValue(String field, String errorCode) {
        this.delegate.rejectValue(field, errorCode);
    }

    public void rejectValue(String field, String errorCode, String defaultMessage) {
        this.delegate.rejectValue(field, errorCode, defaultMessage);
    }

    public void rejectValue(String field, String errorCode, Object[] errorArgs, String defaultMessage) {
        this.delegate.rejectValue(field, errorCode, errorArgs, defaultMessage);
    }

    public void addAllErrors(Errors errors) {
        this.delegate.addAllErrors(errors);
    }

    public boolean hasErrors() {
        return this.hasGlobalErrors() || this.hasFieldErrors();
    }

    public int getErrorCount() {
        return this.delegate.getErrorCount();
    }

    public List<ObjectError> getAllErrors() {
        return this.delegate.getAllErrors();
    }

    public boolean hasGlobalErrors() {
        return this.delegate.hasGlobalErrors();
    }

    public int getGlobalErrorCount() {
        return this.delegate.getGlobalErrorCount();
    }

    public List<ObjectError> getGlobalErrors() {
        return this.delegate.getGlobalErrors();
    }

    public ObjectError getGlobalError() {
        return this.delegate.getGlobalError();
    }

    public boolean hasFieldErrors() {
        return this.getFieldErrorCount() != 0;
    }

    public int getFieldErrorCount() {
        return this.getFieldErrors().size();
    }

    public List<FieldError> getFieldErrors() {
        return Lists.newArrayList((Iterable)Collections2.filter((Collection)this.delegate.getFieldErrors(), (Predicate)new /* Unavailable Anonymous Inner Class!! */));
    }

    public FieldError getFieldError() {
        Iterator iterator = this.getFieldErrors().iterator();
        return iterator.hasNext() ? (FieldError)iterator.next() : null;
    }

    public boolean hasFieldErrors(String field) {
        return !this.ignoreFieldPredicate.apply((Object)field) && this.delegate.hasFieldErrors(field);
    }

    public int getFieldErrorCount(String field) {
        return this.ignoreFieldPredicate.apply((Object)field) ? 0 : this.delegate.getFieldErrorCount(field);
    }

    public List<FieldError> getFieldErrors(String field) {
        return this.ignoreFieldPredicate.apply((Object)field) ? Collections.emptyList() : this.delegate.getFieldErrors(field);
    }

    public FieldError getFieldError(String field) {
        return this.ignoreFieldPredicate.apply((Object)field) ? null : this.delegate.getFieldError(field);
    }

    public Object getFieldValue(String field) {
        return this.delegate.getFieldValue(field);
    }

    public Class getFieldType(String field) {
        return this.delegate.getFieldType(field);
    }

    static /* synthetic */ Predicate access$000(FilteredErrors x0) {
        return x0.ignoreFieldPredicate;
    }
}

