/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.users;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.ServiceUser;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.bitbucket.user.UserType;
import com.atlassian.stash.internal.avatar.InternalAvatarService;
import com.atlassian.stash.internal.project.InternalProjectService;
import com.atlassian.stash.internal.web.users.AbstractProfileController;
import com.atlassian.stash.internal.web.util.ResponseFactory;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/bots/{userSlug}"})
public class ServiceUserProfileController
extends AbstractProfileController {
    private final InternalAvatarService avatarService;
    private final NavBuilder navBuilder;

    @Autowired
    public ServiceUserProfileController(AuthenticationContext authenticationContext, I18nService i18nService, InternalAvatarService avatarService, InternalProjectService projectService, NavBuilder navBuilder, RepositoryService repositoryService, UserService userService) {
        super(authenticationContext, i18nService, projectService, repositoryService, userService);
        this.avatarService = avatarService;
        this.navBuilder = navBuilder;
    }

    @RequestMapping(value={"/avatar.png"}, method={RequestMethod.GET}, produces={"image/png"})
    public void retrieveAvatar(@PathVariable(value="userSlug") String slug, @RequestParam(defaultValue="256", value="s") int size, HttpServletRequest request, HttpServletResponse response) throws IOException {
        ServiceUser user = this.userService.getServiceUserBySlug(slug);
        if (user == null) {
            this.streamAvatar(this.avatarService.getUserDefault(size), request, response);
        } else {
            this.retrieveAvatar((ApplicationUser)user, size, request, response);
        }
    }

    @RequestMapping(method={RequestMethod.GET})
    public ModelAndView showProfile(@PathVariable(value="userSlug") String slug) {
        return this.showProfile(this.getServiceUserOrThrow(slug));
    }

    @RequestMapping(value={"/avatar.png"}, consumes={"application/x-www-form-urlencoded"}, method={RequestMethod.POST})
    public ResponseEntity<Void> uploadAvatar(@PathVariable(value="userSlug") String slug, @RequestParam(value="avatar") String uri) {
        ApplicationUser user = this.getServiceUserOrThrow(slug);
        this.userService.updateAvatar(user, uri);
        return ResponseFactory.created((String)this.navBuilder.user(user).avatar(256).buildAbsolute());
    }

    @Nonnull
    private ApplicationUser getServiceUserOrThrow(String slug) {
        ServiceUser user = this.userService.getServiceUserBySlug(slug);
        if (user == null || user.getType() != UserType.SERVICE) {
            throw this.newNoSuchUserBySlugException(slug);
        }
        return user;
    }
}

