/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.users;

import com.atlassian.bitbucket.mail.MailException;
import com.atlassian.bitbucket.mail.MailService;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.DetailedUser;
import com.atlassian.bitbucket.user.UserAdminService;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.stash.internal.crowd.CrowdControl;
import com.atlassian.stash.internal.web.auth.IgnoresXsrf;
import com.atlassian.stash.internal.web.soy.StashSoyResponseBuilder;
import com.atlassian.stash.internal.web.users.ResetPasswordForm;
import com.google.common.annotations.VisibleForTesting;
import java.security.Principal;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PasswordResetController {
    @VisibleForTesting
    static final String RESET_PASSWORD_FORM = "bitbucket.internal.page.users.passwordreset.passwordReset";
    @VisibleForTesting
    static final String RESET_PASSWORD_ACKNOWLEDGMENT = "bitbucket.internal.page.users.passwordreset.passwordResetReceived";
    private static final Logger log = LoggerFactory.getLogger(PasswordResetController.class);
    private static final String CONFIRM_RESET_PASSWORD = "bitbucket.internal.page.users.passwordresetConfirm.passwordResetConfirm";
    private static final String CONFIRM_PASSWORD_SET = "bitbucket.internal.page.users.passwordset.passwordSet";
    private final CrowdControl crowdControl;
    private final ExecutorService executorService;
    private final MailService mailService;
    private final UserAdminService userAdminService;
    private final UserService userService;

    @Autowired
    public PasswordResetController(CrowdControl crowdControl, @Qualifier(value="passwordResetExecutorService") ExecutorService executorService, MailService mailService, UserAdminService userAdminService, UserService userService) {
        this.crowdControl = crowdControl;
        this.executorService = executorService;
        this.mailService = mailService;
        this.userAdminService = userAdminService;
        this.userService = userService;
    }

    @RequestMapping(value={"/passwordreset"}, method={RequestMethod.GET}, params={"token"})
    public ModelAndView displayPasswordForm(@RequestParam String token) {
        DetailedUser user = this.userAdminService.findUserByPasswordResetToken(token);
        return new ModelAndView(CONFIRM_RESET_PASSWORD, "form", (Object)new ResetPasswordForm(token, (Principal)user));
    }

    @RequestMapping(value={"/passwordreset"}, method={RequestMethod.GET})
    public ModelAndView displayRequestForm() {
        return this.buildRequestForm(false);
    }

    @RequestMapping(value={"/passwordreset"}, method={RequestMethod.POST}, params={"token"})
    @IgnoresXsrf
    public ModelAndView resetPassword(@Valid ResetPasswordForm form, Errors errors) {
        if (errors.hasErrors()) {
            return ((StashSoyResponseBuilder)new StashSoyResponseBuilder(CONFIRM_RESET_PASSWORD).put("form", (Object)form)).putValidationErrors(errors).build();
        }
        try {
            this.userAdminService.resetPassword(form.getToken(), form.getPassword());
        }
        catch (Exception e) {
            return ((StashSoyResponseBuilder)((StashSoyResponseBuilder)new StashSoyResponseBuilder(CONFIRM_RESET_PASSWORD).put("form", (Object)form)).putFormErrors(new String[]{e.getLocalizedMessage()})).build();
        }
        return new ModelAndView(CONFIRM_PASSWORD_SET);
    }

    @RequestMapping(value={"/passwordreset"}, method={RequestMethod.POST})
    @IgnoresXsrf
    public ModelAndView submitRequest(@RequestParam String identifier) {
        if (StringUtils.isBlank((CharSequence)identifier)) {
            return this.buildRequestForm(true);
        }
        try {
            this.executorService.submit(() -> {
                ApplicationUser user = this.userService.findUserByNameOrEmail(identifier);
                if (user == null) {
                    log.info("A password reset was requested for an unknown user " + identifier);
                } else if (!this.crowdControl.canResetPassword(user.getName())) {
                    log.info("The authentication backend is unable to reset the password for " + identifier);
                } else {
                    try {
                        this.userAdminService.requestPasswordReset(user.getName());
                    }
                    catch (MailException e) {
                        log.error("A password reset e-mail could not be sent for " + identifier, (Throwable)e);
                    }
                    catch (Exception e) {
                        log.error("A password reset could not be performed for " + identifier, (Throwable)e);
                    }
                }
            });
        }
        catch (RejectedExecutionException e) {
            log.warn("A password reset was rejected for " + identifier + " because of too many concurrent requests");
        }
        return new ModelAndView(RESET_PASSWORD_ACKNOWLEDGMENT);
    }

    private ModelAndView buildRequestForm(boolean submittedEmptyIdentifier) {
        return ((StashSoyResponseBuilder)((StashSoyResponseBuilder)new StashSoyResponseBuilder(RESET_PASSWORD_FORM).put("canSendEmail", (Object)this.mailService.isHostConfigured())).put("submittedEmptyIdentifier", (Object)submittedEmptyIdentifier)).build();
    }
}

