/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.users;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.stash.internal.project.InternalProjectService;
import com.atlassian.stash.internal.web.users.AbstractProfileController;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/profile"})
public class CurrentUserProfileController
extends AbstractProfileController {
    @Autowired
    public CurrentUserProfileController(AuthenticationContext authenticationContext, I18nService i18nService, InternalProjectService projectService, RepositoryService repositoryService, UserService userService) {
        super(authenticationContext, i18nService, projectService, repositoryService, userService);
    }

    @RequestMapping(value={"/avatar.png"}, method={RequestMethod.GET}, produces={"image/png"})
    public void retrieveAvatar(@RequestParam(defaultValue="256", value="s") int size, HttpServletRequest request, HttpServletResponse response) throws IOException {
        super.retrieveAvatar(this.getCurrentUserOrThrow(), size, request, response);
    }

    @RequestMapping
    public ModelAndView showProfile() {
        return this.showProfile(this.getCurrentUserOrThrow());
    }

    @Nonnull
    private ApplicationUser getCurrentUserOrThrow() {
        ApplicationUser user = this.authenticationContext.getCurrentUser();
        if (user == null) {
            throw new AccessDeniedException(this.i18nService.getMessage("bitbucket.web.profile.avatarforanonymous", new Object[0]));
        }
        return user;
    }
}

