/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.users;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.project.PersonalProject;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.bitbucket.user.UserType;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.stash.internal.project.InternalProjectService;
import com.atlassian.stash.internal.web.soy.StashSoyResponseBuilder;
import com.atlassian.stash.internal.web.util.AvatarSupport;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.ModelAndView;

public abstract class AbstractProfileController
extends AvatarSupport {
    public static final String OTHERS_PROFILE_VIEW = "bitbucket.internal.page.users.profile.profile.othersProfile";
    public static final String OWN_PROFILE_VIEW = "bitbucket.internal.page.users.profile.profile.ownProfile";
    public static final String SERVICE_USER_PROFILE_VIEW = "bitbucket.internal.page.users.profile.profile.serviceUserProfile";
    protected final AuthenticationContext authenticationContext;
    protected final RepositoryService repositoryService;
    protected final UserService userService;
    private final InternalProjectService projectService;

    protected AbstractProfileController(AuthenticationContext authenticationContext, I18nService i18nService, InternalProjectService projectService, RepositoryService repositoryService, UserService userService) {
        super(i18nService);
        this.authenticationContext = authenticationContext;
        this.projectService = projectService;
        this.repositoryService = repositoryService;
        this.userService = userService;
    }

    protected void retrieveAvatar(@Nonnull ApplicationUser user, int size, @Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response) throws IOException {
        this.streamAvatar(this.userService.getAvatar(user, size), request, response);
    }

    protected ModelAndView showProfile(@Nonnull ApplicationUser user) {
        if (user.getType() == UserType.SERVICE) {
            return ((StashSoyResponseBuilder)new StashSoyResponseBuilder(SERVICE_USER_PROFILE_VIEW).put("user", (Object)user)).build();
        }
        PersonalProject project = this.projectService.getPersonalProject(user);
        boolean isCurrentUser = user.equals(this.authenticationContext.getCurrentUser());
        return ((StashSoyResponseBuilder)((StashSoyResponseBuilder)new StashSoyResponseBuilder(isCurrentUser ? OWN_PROFILE_VIEW : OTHERS_PROFILE_VIEW).put("repositoryPage", (Object)this.repositoryService.findByOwner(user, PageUtils.newRequest((int)0, (int)25)))).put("user", (Object)user)).putProject((Project)project).build();
    }
}

