/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.timezone;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.timezone.TimeZoneService;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.usersettings.UserSettingsService;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.atlassian.stash.internal.locale.InternalLocaleService;
import com.atlassian.stash.internal.web.timezone.AbstractTimeZoneFormFragment;
import com.atlassian.stash.internal.web.timezone.LocalizedZoneCollection;
import com.atlassian.stash.internal.web.timezone.TimeZoneOffsetHelper;
import com.google.common.annotations.VisibleForTesting;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class UserTimeZoneFormFragment
extends AbstractTimeZoneFormFragment {
    private final AuthenticationContext authenticationContext;
    private final I18nService i18nService;
    private final InternalLocaleService localeService;
    private final TimeZoneService timeZoneService;
    private final UserSettingsService settingsService;

    UserTimeZoneFormFragment(@Nonnull AuthenticationContext authenticationContext, @Nonnull I18nService i18nService, @Nonnull InternalLocaleService localeService, @Nonnull SoyTemplateRenderer soyTemplateRenderer, @Nonnull TimeZoneService timeZoneService, @Nonnull UserSettingsService settingsService) {
        super(i18nService, localeService, soyTemplateRenderer);
        this.authenticationContext = authenticationContext;
        this.i18nService = i18nService;
        this.localeService = localeService;
        this.timeZoneService = timeZoneService;
        this.settingsService = settingsService;
    }

    void execute(@Nullable ZoneId zoneId) {
        this.timeZoneService.setUserTimeZone(zoneId);
        this.updateOnboardingUserSetting(zoneId);
    }

    @Nonnull
    Optional<ZoneId> getCurrent() {
        return this.timeZoneService.getUserTimeZone();
    }

    @Nonnull
    LocalizedZoneCollection.LocalizedTimeZone getDefaultTimeZone() {
        return LocalizedZoneCollection.timeZone((ZoneId)this.timeZoneService.getDefaultTimeZone(), (Locale)this.localeService.getLocale(), (String)this.i18nService.getMessage("bitbucket.web.timezone.default.time.zone", new Object[0]), (String)"");
    }

    @Nonnull
    String getDescription() {
        return "";
    }

    boolean isLongField() {
        return false;
    }

    @VisibleForTesting
    void updateOnboardingUserSetting(ZoneId zoneId) {
        this.settingsService.updateUserSettings(UserKey.fromLong((long)this.authenticationContext.getCurrentUser().getId()), settings -> {
            long offset = zoneId == null ? TimeZoneOffsetHelper.toGmtDifferenceInMinutes((ZoneId)this.timeZoneService.getDefaultTimeZone(), (Instant)Instant.now()) : TimeZoneOffsetHelper.toGmtDifferenceInMinutes((ZoneId)zoneId, (Instant)Instant.now());
            settings.put("USER_BROWSER_TIME_ZONE_OFFSET", offset);
            return settings.build();
        });
    }
}

