/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.timezone;

import com.atlassian.stash.internal.web.timezone.LocalizedZoneCollection;
import com.google.common.collect.TreeMultimap;
import io.atlassian.fugue.Pair;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.TextStyle;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

/*
 * Exception performing whole class analysis ignored.
 */
class LocalizedZoneCollection {
    private static final String GMT = "GMT";
    private final List<Region> regions;

    LocalizedZoneCollection(@Nonnull Locale locale) {
        TreeMultimap regionMap = TreeMultimap.create();
        ZoneId.getAvailableZoneIds().stream().map(ZoneId::of).filter(zoneId -> !zoneId.getId().startsWith("Etc/")).forEach(zoneId -> LocalizedZoneCollection.getRegion((ZoneId)zoneId).ifPresent(regionPlace -> regionMap.put(regionPlace.left(), (Object)LocalizedZoneCollection.timeZone((ZoneId)zoneId, (Locale)locale, (String)((String)regionPlace.right())))));
        for (int i = -12; i <= 12; ++i) {
            String offsetLabel = (i == 0 ? "" : (i > 0 ? "+" : "")) + i;
            ZoneId zoneId2 = ZoneId.of("GMT" + offsetLabel);
            regionMap.put((Object)"GMT", (Object)LocalizedZoneCollection.timeZone((ZoneId)zoneId2, (Locale)locale));
        }
        this.regions = regionMap.asMap().entrySet().stream().map(entry -> new Region((String)entry.getKey(), (Collection)entry.getValue(), null)).collect(Collectors.toList());
    }

    public List<Region> getRegions() {
        return this.regions;
    }

    static LocalizedTimeZone timeZone(@Nonnull ZoneId zoneId, @Nonnull Locale locale, @Nonnull String label, @Nonnull String id) {
        return new LocalizedTimeZone(id, label, zoneId.getDisplayName(TextStyle.FULL, locale), LocalDateTime.now().atZone(zoneId).getOffset().toString(), null);
    }

    private static LocalizedTimeZone timeZone(@Nonnull ZoneId zoneId, @Nonnull Locale locale, @Nonnull String label) {
        return LocalizedZoneCollection.timeZone((ZoneId)zoneId, (Locale)locale, (String)label, (String)zoneId.getId());
    }

    private static LocalizedTimeZone timeZone(@Nonnull ZoneId zoneId, @Nonnull Locale locale) {
        return LocalizedZoneCollection.timeZone((ZoneId)zoneId, (Locale)locale, (String)zoneId.getId());
    }

    private static Optional<Pair<String, String>> getRegion(ZoneId zoneId) {
        int lastSlash = zoneId.getId().lastIndexOf(47);
        String id = zoneId.getId();
        if (lastSlash > 0) {
            return Optional.of(Pair.pair((Object)LocalizedZoneCollection.toLabel((String)id.substring(0, lastSlash)), (Object)LocalizedZoneCollection.toLabel((String)id.substring(lastSlash + 1))));
        }
        return Optional.empty();
    }

    private static String toLabel(String value) {
        return value.replaceAll("_", " ");
    }
}

