/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.soy.functions.nav;

import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.soy.renderer.JsExpression;
import com.atlassian.soy.renderer.SoyClientFunction;
import com.atlassian.soy.renderer.SoyServerFunction;
import com.atlassian.stash.internal.web.soy.functions.SoyArgumentUtils;
import com.atlassian.stash.internal.web.soy.functions.nav.NavOptionsUtils;
import com.google.common.collect.ImmutableSet;
import java.util.Set;

public class PluginResourceUrlFunction
implements SoyServerFunction<String>,
SoyClientFunction {
    private final WebResourceUrlProvider webResourceUrlProvider;
    private final NavBuilder navBuilder;

    public PluginResourceUrlFunction(WebResourceUrlProvider webResourceUrlProvider, NavBuilder navBuilder) {
        this.webResourceUrlProvider = webResourceUrlProvider;
        this.navBuilder = navBuilder;
    }

    public String getName() {
        return "plugin_resource";
    }

    public JsExpression generate(JsExpression ... jsExpressions) {
        String moduleCompleteKey = this.parseStringLiteral(jsExpressions[0]);
        String resourceName = this.parseStringLiteral(jsExpressions[1]);
        return this.asJsExpression(this.getResourceUrl(moduleCompleteKey, resourceName, UrlMode.RELATIVE));
    }

    public String apply(Object ... args) {
        String moduleCompleteKey = (String)SoyArgumentUtils.checkType((Object[])args, String.class, (int)0);
        String resourceName = (String)SoyArgumentUtils.checkType((Object[])args, String.class, (int)1);
        return NavOptionsUtils.withNavOptions((NavOptionsUtils.NavOptionsCallback)new /* Unavailable Anonymous Inner Class!! */, (Object[])args);
    }

    public Set<Integer> validArgSizes() {
        return ImmutableSet.of((Object)2, (Object)3);
    }

    private String getResourceUrl(String moduleCompleteKey, String resourceName, UrlMode mode) {
        return this.webResourceUrlProvider.getStaticPluginResourceUrl(moduleCompleteKey, resourceName, mode);
    }

    private String parseStringLiteral(JsExpression expression) {
        String text = expression.getText();
        if (text.startsWith("\"") && text.endsWith("\"") || text.startsWith("'") && text.endsWith("'")) {
            return text.substring(1, text.length() - 1).replaceAll("\\\\([\"'])", "\\$1");
        }
        throw new IllegalArgumentException("expression passed to plugin_resource was not a literal String.");
    }

    private JsExpression asJsExpression(String s) {
        if (s == null) {
            return new JsExpression("null");
        }
        return new JsExpression("'" + s.replaceAll("'", "\\'") + "'");
    }

    static /* synthetic */ String access$000(PluginResourceUrlFunction x0, String x1, String x2, UrlMode x3) {
        return x0.getResourceUrl(x1, x2, x3);
    }

    static /* synthetic */ NavBuilder access$100(PluginResourceUrlFunction x0) {
        return x0.navBuilder;
    }
}

