/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.soy.functions.help;

import com.atlassian.bitbucket.help.HelpPathService;
import com.atlassian.soy.renderer.JsExpression;
import com.atlassian.soy.renderer.SoyClientFunction;
import com.atlassian.soy.renderer.SoyServerFunction;
import com.atlassian.stash.internal.web.soy.functions.SoyArgumentUtils;
import com.google.common.base.Preconditions;
import java.util.Set;
import java.util.regex.Pattern;

public class HelpUrlFunction
implements SoyServerFunction<String>,
SoyClientFunction {
    private static final Set<Integer> VALID_ARG_SIZES = SoyArgumentUtils.argCountOf((int)1);
    private static final Pattern LITERAL_PATTERN = Pattern.compile("'(\\\\.|[^'])*'");
    private final HelpPathService helpPathService;

    public HelpUrlFunction(HelpPathService helpPathService) {
        this.helpPathService = helpPathService;
    }

    public String getName() {
        return "bitbucket_help_url";
    }

    public JsExpression generate(JsExpression ... jsExpressions) {
        Preconditions.checkArgument((jsExpressions.length == 1 ? 1 : 0) != 0, (Object)"Wrong number of arguments (1 expected)");
        Preconditions.checkArgument((boolean)LITERAL_PATTERN.matcher(jsExpressions[0].getText()).matches(), (Object)"The first argument, the help key name, should be a string literal");
        return new JsExpression("bitbucket_help_url(" + jsExpressions[0].getText() + ")");
    }

    public String apply(Object ... args) {
        Preconditions.checkArgument((args.length == 1 ? 1 : 0) != 0, (Object)"Wrong number of arguments (1 expected)");
        Preconditions.checkArgument((boolean)(args[0] instanceof String), (Object)"The first argument, the help key name, should be a string");
        String helpPageUrl = this.helpPathService.getPageUrl((String)args[0]);
        return helpPageUrl == null ? "" : helpPageUrl;
    }

    public Set<Integer> validArgSizes() {
        return VALID_ARG_SIZES;
    }
}

