/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.soy.functions;

import com.atlassian.soy.renderer.JsExpression;
import com.atlassian.soy.renderer.SanitizedString;
import com.atlassian.soy.renderer.SoyClientFunction;
import com.atlassian.soy.renderer.SoyServerFunction;
import com.atlassian.stash.internal.web.fragments.WebFragmentSupport;
import com.atlassian.stash.internal.web.fragments.WebPanelData;
import com.atlassian.stash.internal.web.soy.functions.SoyArgumentUtils;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class WebPanelFunction
implements SoyServerFunction<List<SanitizedString>>,
SoyClientFunction {
    private static final Set<Integer> VALID_ARG_SIZES = SoyArgumentUtils.argCountFromTo((int)1, (int)2);
    private final WebFragmentSupport webFragmentSupport;

    public WebPanelFunction(WebFragmentSupport webFragmentSupport) {
        this.webFragmentSupport = webFragmentSupport;
    }

    public String getName() {
        return "getWebPanels";
    }

    public JsExpression generate(JsExpression ... args) {
        Preconditions.checkArgument((boolean)VALID_ARG_SIZES.contains(args.length), (String)"invalid number of arguments: %s", (int)args.length);
        return new JsExpression("WebFragments.getWebPanels(" + args[0].getText() + (args.length > 1 ? "," + args[1].getText() : "") + ").map(function(webPanel) { return soydata.VERY_UNSAFE.ordainSanitizedHtml(webPanel); })");
    }

    public List<SanitizedString> apply(Object ... args) {
        Preconditions.checkArgument((boolean)VALID_ARG_SIZES.contains(args.length), (String)"invalid number of arguments: %s", (int)args.length);
        String location = (String)args[0];
        Map context = null;
        if (args.length == 2) {
            context = (Map)args[1];
        }
        return this.webFragmentSupport.getWebPanels(location, context, false).stream().map(WebPanelData::getHtml).map(SanitizedString::new).collect(Collectors.toList());
    }

    public Set<Integer> validArgSizes() {
        return VALID_ARG_SIZES;
    }
}

