/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.soy.functions;

import com.atlassian.bitbucket.scope.ScopeType;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.soy.renderer.JsExpression;
import com.atlassian.soy.renderer.SoyClientFunction;
import com.atlassian.soy.renderer.SoyServerFunction;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;

public class ResolveScopeTypeFunction
implements SoyClientFunction,
SoyServerFunction<Map<String, Boolean>> {
    public String getName() {
        return "resolve_scopetype";
    }

    public JsExpression generate(JsExpression ... args) {
        this.checkArgSize((Object[])args);
        return new JsExpression("require('bitbucket/internal/util/scope-type').resolveForScopeType(" + args[0].getText() + ")");
    }

    public Set<Integer> validArgSizes() {
        return ImmutableSet.of((Object)1);
    }

    public Map<String, Boolean> apply(Object ... args) {
        this.checkArgSize(args);
        Preconditions.checkArgument((boolean)(args[0] instanceof ScopeType), (Object)String.format("The given argument, %s, must be an instance of ScopeType", args[0]));
        return (Map)Arrays.stream(ScopeType.values()).collect(MoreCollectors.toImmutableMap(Enum::name, scopeType -> scopeType == args[0]));
    }

    private void checkArgSize(Object ... args) {
        Preconditions.checkArgument((boolean)this.validArgSizes().contains(args.length), (Object)String.format("Invalid number of arguments supplied. Expected: %s, actual: %s", this.validArgSizes(), args.length));
    }
}

