/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.soy.functions;

import com.atlassian.soy.renderer.SanitizationType;
import com.atlassian.soy.renderer.SanitizedString;
import com.atlassian.soy.renderer.SoyServerFunction;
import com.atlassian.stash.internal.plugin.web.fragments.ClientWebFragmentType;
import com.atlassian.stash.internal.web.fragments.WebFragmentData;
import com.atlassian.stash.internal.web.fragments.WebFragmentSupport;
import com.atlassian.stash.internal.web.fragments.WebItemData;
import com.atlassian.stash.internal.web.fragments.WebPanelData;
import com.atlassian.stash.internal.web.fragments.WebSectionData;
import com.atlassian.stash.internal.web.soy.functions.SoyArgumentUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Set;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenderServerFragmentsForClientFunction
implements SoyServerFunction<SanitizedString> {
    @VisibleForTesting
    static final CharMatcher JS_SEPARATORS = CharMatcher.anyOf((CharSequence)"\u2028\u2029");
    private static final Logger log = LoggerFactory.getLogger(RenderServerFragmentsForClientFunction.class);
    private static final Set<Integer> VALID_ARG_SIZES = SoyArgumentUtils.argCountFromTo((int)2, (int)2);
    private final JsonFactory jsonFactory;
    private final WebFragmentSupport webFragmentSupport;

    public RenderServerFragmentsForClientFunction(WebFragmentSupport webFragmentSupport) {
        this.webFragmentSupport = webFragmentSupport;
        this.jsonFactory = new ObjectMapper().getJsonFactory();
    }

    public String getName() {
        return "renderServerFragmentsForClient";
    }

    public SanitizedString apply(Object ... args) {
        Preconditions.checkArgument((boolean)VALID_ARG_SIZES.contains(args.length), (String)"invalid number of arguments: %s", (int)args.length);
        String location = (String)SoyArgumentUtils.checkType((Object[])args, String.class, (int)0);
        List fragments = (List)SoyArgumentUtils.checkType((Object[])args, List.class, (int)1);
        if (fragments.size() == 0) {
            return new SanitizedString("");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<script>\n");
        for (WebFragmentData fragment : fragments) {
            String addDescriptorMethod;
            StringWriter writer;
            block19: {
                writer = new StringWriter();
                addDescriptorMethod = null;
                try {
                    JsonGenerator generator = this.jsonFactory.createJsonGenerator((Writer)writer);
                    Throwable throwable = null;
                    try {
                        String formattedLocation;
                        String string = formattedLocation = fragment.getParent() != null ? this.webFragmentSupport.formatLocation(location, fragment.getParent()) : location;
                        if (fragment instanceof WebItemData) {
                            addDescriptorMethod = ClientWebFragmentType.ITEM.getAddDescriptorJsMethod();
                            this.writeDescriptor(generator, (WebItemData)fragment, formattedLocation);
                            break block19;
                        }
                        if (fragment instanceof WebSectionData) {
                            addDescriptorMethod = ClientWebFragmentType.SECTION.getAddDescriptorJsMethod();
                            this.writeDescriptor(generator, (WebSectionData)fragment, formattedLocation);
                            break block19;
                        }
                        if (fragment instanceof WebPanelData) {
                            addDescriptorMethod = ClientWebFragmentType.PANEL.getAddDescriptorJsMethod();
                            this.writeDescriptor(generator, (WebPanelData)fragment, formattedLocation);
                            break block19;
                        }
                        log.warn("Unexpected WebFragmentData type while rendering server fragments to JS.");
                        continue;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (generator == null) continue;
                        if (throwable != null) {
                            try {
                                generator.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        generator.close();
                        continue;
                    }
                }
                catch (IOException e) {
                    log.error("Exception while rendering server fragments to JS:", (Throwable)e);
                }
            }
            if (addDescriptorMethod == null) continue;
            sb.append(addDescriptorMethod).append("(").append(writer.toString()).append(");\n");
        }
        sb.append("</script>");
        return new SanitizedString(sb.toString(), SanitizationType.HTML);
    }

    private String escapeJs(String s) {
        return JS_SEPARATORS.replaceFrom((CharSequence)s, (CharSequence)"\\n").replaceAll("/", "\\/");
    }

    private void stringField(JsonGenerator json, String name, String value) throws IOException {
        json.writeStringField(name, this.escapeJs(value));
    }

    private void optionalStringField(JsonGenerator json, String name, String value) throws IOException {
        if (value != null) {
            this.stringField(json, name, value);
        }
    }

    private void writeDefaultProps(JsonGenerator generator, WebFragmentData fragment, String location) throws IOException {
        this.stringField(generator, "completeModuleKey", fragment.getCompleteKey());
        this.stringField(generator, "key", fragment.getKey());
        this.stringField(generator, "moduleKey", fragment.getModuleKey());
        generator.writeObjectField("params", (Object)fragment.getParams());
        this.stringField(generator, "pluginKey", fragment.getPluginKey());
        this.stringField(generator, "location", location);
        generator.writeNumberField("weight", fragment.getWeight());
    }

    private void writeDescriptor(JsonGenerator generator, WebItemData item, String location) throws IOException {
        generator.writeStartObject();
        this.writeDefaultProps(generator, (WebFragmentData)item, location);
        this.optionalStringField(generator, "url", item.getUrl());
        this.optionalStringField(generator, "linkText", item.getLinkText());
        this.optionalStringField(generator, "linkId", item.getLinkId());
        this.optionalStringField(generator, "styleClass", item.getStyleClass());
        this.optionalStringField(generator, "tooltip", item.getTooltip());
        generator.writeEndObject();
    }

    private void writeDescriptor(JsonGenerator generator, WebSectionData section, String location) throws IOException {
        generator.writeStartObject();
        this.writeDefaultProps(generator, (WebFragmentData)section, location);
        this.optionalStringField(generator, "labelText", section.getLabelText());
        generator.writeEndObject();
    }

    private void writeDescriptor(JsonGenerator generator, WebPanelData panel, String location) throws IOException {
        generator.writeStartObject();
        this.writeDefaultProps(generator, (WebFragmentData)panel, location);
        this.optionalStringField(generator, "html", panel.getHtml());
        generator.writeEndObject();
    }

    public Set<Integer> validArgSizes() {
        return VALID_ARG_SIZES;
    }
}

