/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.soy.functions;

import com.atlassian.bitbucket.server.Feature;
import com.atlassian.bitbucket.server.FeatureManager;
import com.atlassian.bitbucket.server.StandardFeature;
import com.atlassian.soy.renderer.JsExpression;
import com.atlassian.soy.renderer.SoyClientFunction;
import com.atlassian.soy.renderer.SoyServerFunction;
import com.atlassian.stash.internal.web.soy.functions.SoyArgumentUtils;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;

public class IsFeatureEnabledFunction
implements SoyServerFunction<Boolean>,
SoyClientFunction {
    private static final Pattern LITERAL_STRING = Pattern.compile("^'(.*)'$");
    private static final Set<Integer> VALID_ARGS = ImmutableSet.of((Object)1);
    private final FeatureManager featureManager;

    public IsFeatureEnabledFunction(FeatureManager featureManager) {
        this.featureManager = featureManager;
    }

    public Boolean apply(Object ... args) {
        String featureKey = SoyArgumentUtils.getStringArgument((Object[])args, (int)0);
        StandardFeature feature = StandardFeature.fromKey((String)featureKey);
        return this.featureManager.isEnabled((Feature)feature);
    }

    public JsExpression generate(JsExpression ... args) {
        JsExpression featureKeyAsStringLiteral = args[0];
        Matcher matcher = LITERAL_STRING.matcher(featureKeyAsStringLiteral.getText());
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Argument to isFeatureEnabled() is not a literal string: " + featureKeyAsStringLiteral.getText());
        }
        String featureKey = StringEscapeUtils.unescapeEcmaScript((String)matcher.group(1));
        StandardFeature feature = StandardFeature.fromKey((String)featureKey);
        return new JsExpression(Boolean.toString(this.featureManager.isEnabled((Feature)feature)));
    }

    public String getName() {
        return "isFeatureEnabled";
    }

    public Set<Integer> validArgSizes() {
        return VALID_ARGS;
    }
}

