/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.soy.functions;

import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.soy.renderer.SoyServerFunction;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Set;

public class HasRepositoryReadFunction
implements SoyServerFunction<Boolean> {
    private final PermissionService permissionService;

    public HasRepositoryReadFunction(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public String getName() {
        return "hasRepoRead";
    }

    public Boolean apply(Object ... args) {
        Preconditions.checkArgument((boolean)(args[0] instanceof Repository), (Object)"Repository must be a repository object");
        Repository repository = (Repository)args[0];
        return this.permissionService.hasRepositoryPermission(repository, Permission.REPO_READ);
    }

    public Set<Integer> validArgSizes() {
        return ImmutableSet.of((Object)1);
    }
}

