/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.soy.functions;

import com.atlassian.bitbucket.util.DateFormatter;
import com.atlassian.soy.renderer.JsExpression;
import com.atlassian.soy.renderer.SoyClientFunction;
import com.atlassian.soy.renderer.SoyServerFunction;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Date;
import java.util.Set;

public class FormatDateFunction
implements SoyServerFunction<String>,
SoyClientFunction {
    private static final Set<Integer> VALID_ARG_SIZES = ImmutableSet.of((Object)2, (Object)3);
    private final DateFormatter dateFormatter;

    public FormatDateFunction(DateFormatter dateFormatter) {
        this.dateFormatter = dateFormatter;
    }

    public String getName() {
        return "format_date";
    }

    public String apply(Object ... args) {
        if (args.length == 3 && args[2] != null) {
            throw new IllegalArgumentException("This method can be called with 3 arguments from the client side but not from the server side");
        }
        Preconditions.checkArgument((args[0] instanceof Date || args[0] instanceof Number ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)(args[1] instanceof String));
        Date date = args[0] instanceof Date ? (Date)args[0] : new Date(((Number)args[0]).longValue());
        DateFormatter.FormatType type = DateFormatter.FormatType.fromString((String)((String)args[1]));
        return this.dateFormatter.formatDate(date, type);
    }

    public JsExpression generate(JsExpression ... args) {
        StringBuilder sb = new StringBuilder();
        sb.append("require('bitbucket/internal/util/time').format(");
        String sep = "";
        for (JsExpression expr : args) {
            sb.append(sep).append(expr.getText());
            sep = ", ";
        }
        sb.append(")");
        return new JsExpression(sb.toString());
    }

    public Set<Integer> validArgSizes() {
        return VALID_ARG_SIZES;
    }
}

