/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.soy.functions;

import com.atlassian.soy.renderer.JsExpression;
import com.atlassian.soy.renderer.SoyClientFunction;
import com.atlassian.soy.renderer.SoyServerFunction;
import com.atlassian.stash.internal.web.soy.functions.SoyArgumentUtils;
import java.util.Set;

public class FirstNonNullFunction
implements SoyServerFunction<Object>,
SoyClientFunction {
    public static final Set<Integer> VALID_ARG_SIZES = SoyArgumentUtils.argCountFromTo((int)2, (int)5);

    public String getName() {
        return "firstNonNull";
    }

    public JsExpression generate(JsExpression ... args) {
        StringBuilder sb = new StringBuilder("[");
        for (int i = 0; i < args.length; ++i) {
            String argText;
            if (i > 0) {
                sb.append(",");
            }
            if ((argText = args[i].getText()).startsWith("opt_data.")) {
                sb.append("opt_data ? ");
                sb.append(argText);
                sb.append(" : null");
                continue;
            }
            sb.append(argText);
        }
        sb.append("].filter(function(x){return x != null;})[0]");
        return new JsExpression(sb.toString());
    }

    public Object apply(Object ... args) {
        for (Object arg : args) {
            if (arg == null) continue;
            return arg;
        }
        return null;
    }

    public Set<Integer> validArgSizes() {
        return VALID_ARG_SIZES;
    }
}

