/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.soy.functions;

import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestService;
import com.atlassian.soy.renderer.SoyServerFunction;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Set;

public class CanDeletePullRequestFunction
implements SoyServerFunction<Boolean> {
    private final PullRequestService pullRequestService;

    public CanDeletePullRequestFunction(PullRequestService pullRequestService) {
        this.pullRequestService = pullRequestService;
    }

    public String getName() {
        return "canDeletePullRequest";
    }

    public Boolean apply(Object ... args) {
        Preconditions.checkArgument((boolean)(args[0] instanceof PullRequest), (Object)"Argument must be a pull request");
        PullRequest pullRequest = (PullRequest)args[0];
        return this.pullRequestService.canDelete(pullRequest.getToRef().getRepository().getId(), pullRequest.getId());
    }

    public Set<Integer> validArgSizes() {
        return ImmutableSet.of((Object)1);
    }
}

