/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.soy;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.timezone.UserTimeZoneSupplier;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.soy.springmvc.InjectedDataFactory;
import com.atlassian.stash.internal.ApplicationConstants;
import com.atlassian.stash.internal.locale.InternalLocaleService;
import com.atlassian.stash.internal.web.timezone.TimeZoneOffsetHelper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import java.time.Instant;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultInjectedDataFactory
implements InjectedDataFactory {
    private final ApplicationPropertiesService propertiesService;
    private final AuthenticationContext authenticationContext;
    private final InternalLocaleService localeService;
    private final UserTimeZoneSupplier userTimeZoneSupplier;
    private final Supplier<Instant> nowSupplier;

    @Autowired
    public DefaultInjectedDataFactory(ApplicationPropertiesService propertiesService, AuthenticationContext authenticationContext, InternalLocaleService localeService, UserTimeZoneSupplier userTimeZoneSupplier) {
        this(propertiesService, authenticationContext, localeService, userTimeZoneSupplier, Instant::now);
    }

    @VisibleForTesting
    DefaultInjectedDataFactory(ApplicationPropertiesService propertiesService, AuthenticationContext authenticationContext, InternalLocaleService localeService, UserTimeZoneSupplier userTimeZoneSupplier, Supplier<Instant> nowSupplier) {
        this.authenticationContext = authenticationContext;
        this.localeService = localeService;
        this.propertiesService = propertiesService;
        this.userTimeZoneSupplier = userTimeZoneSupplier;
        this.nowSupplier = nowSupplier;
    }

    public Map<String, Object> createInjectedData(HttpServletRequest request) {
        HashMap injectedData = Maps.newHashMap();
        ApplicationUser currentUser = this.authenticationContext.getCurrentUser();
        injectedData.put("principal", currentUser);
        ZoneId userTz = this.userTimeZoneSupplier.getTimeZone();
        long offset = TimeZoneOffsetHelper.toGmtDifferenceInMinutes((ZoneId)userTz, (Instant)((Instant)this.nowSupplier.get()));
        injectedData.put("timezone", offset);
        String displayName = this.propertiesService.getDisplayName();
        if (displayName == null) {
            displayName = ApplicationConstants.PRODUCT_NAME;
        }
        injectedData.put("instanceName", displayName);
        injectedData.put("productName", ApplicationConstants.PRODUCT_NAME);
        injectedData.put("language", this.localeService.getLocale().getLanguage());
        injectedData.put("xsrfTokenName", request.getAttribute("xsrfTokenName"));
        injectedData.put("xsrfTokenValue", request.getAttribute("xsrfTokenValue"));
        Object connectHostUrl = request.getAttribute("connectHostUrl");
        if (connectHostUrl instanceof String) {
            injectedData.put("connectHostUrl", connectHostUrl);
        }
        return injectedData;
    }
}

