/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.repos;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.stash.internal.web.repos.ViewRefType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="viewRefTypeHelper")
public class ViewRefTypeHelper {
    private final I18nService i18nService;

    @Autowired
    public ViewRefTypeHelper(I18nService i18nService) {
        this.i18nService = i18nService;
    }

    public ViewRefType getViewRefType(String typeId) {
        String typeName;
        if (ViewRefType.BRANCH.equals(typeId)) {
            typeName = this.i18nService.getMessage("bitbucket.web.revisionref.branch.name", new Object[0]);
        } else if (ViewRefType.TAG.equals(typeId)) {
            typeName = this.i18nService.getMessage("bitbucket.web.revisionref.tag.name", new Object[0]);
        } else if (ViewRefType.COMMIT.equals(typeId)) {
            typeName = this.i18nService.getMessage("bitbucket.web.revisionref.commit.name", new Object[0]);
        } else {
            typeId = ViewRefType.BRANCH;
            typeName = this.i18nService.getMessage("bitbucket.web.revisionref.branch.name", new Object[0]);
        }
        return new ViewRefType(typeId, typeName);
    }
}

