/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.onboarding;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.UrlUtils;
import com.atlassian.sal.api.usersettings.UserSettings;
import com.atlassian.stash.internal.user.InternalUserSettingsService;
import com.atlassian.stash.internal.web.soy.StashSoyResponseBuilder;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class OnboardingController {
    static final String GETTING_STARTED = "bitbucket.internal.page.gettingStarted.gettingStarted.gettingstarted";
    static final String WAS_REDIRECTED = "wasRedirected";
    private static final String NEXT_URL = "nextUrl";
    private final AuthenticationContext authenticationContext;
    private final InternalUserSettingsService userSettingsService;
    private final NavBuilder navBuilder;

    @Autowired
    public OnboardingController(AuthenticationContext authenticationContext, InternalUserSettingsService userSettingsService, NavBuilder navBuilder) {
        this.authenticationContext = authenticationContext;
        this.userSettingsService = userSettingsService;
        this.navBuilder = navBuilder;
    }

    @RequestMapping(value={"/getting-started"}, method={RequestMethod.GET})
    public ModelAndView gettingStarted(@RequestParam(value="next", required=false) String nextUrl, @RequestHeader(value="referer", required=false) String referrer, HttpServletRequest request) {
        ImmutableMap context = ImmutableMap.of((Object)WAS_REDIRECTED, (Object)this.showGettingStarted());
        if (StringUtils.isBlank((CharSequence)nextUrl)) {
            nextUrl = StringUtils.isBlank((CharSequence)referrer) ? request.getContextPath() : UrlUtils.getPathAndQuery((String)referrer);
        }
        return this.render(GETTING_STARTED, nextUrl, "/getting-started", (Map)context, request);
    }

    private ModelAndView render(String template, String nextUrl, String requestPath, Map<String, Object> context, HttpServletRequest request) {
        StashSoyResponseBuilder builder = new StashSoyResponseBuilder(template);
        if (context != null) {
            builder.putAll(context);
        }
        builder.put(NEXT_URL, (Object)(StringUtils.isBlank((CharSequence)nextUrl) || nextUrl.contains(requestPath) ? request.getContextPath() : nextUrl));
        return builder.build();
    }

    private boolean showGettingStarted() {
        ApplicationUser currentUser = this.authenticationContext.getCurrentUser();
        UserSettings userSettings = this.userSettingsService.getUserSettings(currentUser);
        boolean showGettingStarted = (Boolean)userSettings.getBoolean("SHOW_GETTING_STARTED_PAGE").getOrElse((Object)false);
        if (showGettingStarted) {
            this.updateUserSettings();
        }
        return showGettingStarted;
    }

    private void updateUserSettings() {
        ApplicationUser currentUser = this.authenticationContext.getCurrentUser();
        if (currentUser != null) {
            this.userSettingsService.updateUserSettings(currentUser, input -> input.remove("SHOW_GETTING_STARTED_PAGE").build());
        }
    }
}

