/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.markup;

import com.atlassian.bitbucket.AuthorisationException;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.util.MarkupUtils;
import com.atlassian.markup.renderer.MarkupRendererComponent;
import com.atlassian.markup.renderer.RenderContext;
import com.atlassian.markup.renderer.RenderTransform;
import com.google.common.base.MoreObjects;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="pullRequestMarkupRenderer")
public class PullRequestMarkupRenderer
implements MarkupRendererComponent {
    private static final Logger log = LoggerFactory.getLogger(PullRequestMarkupRenderer.class);
    private static final Pattern PULL_REQUEST_PATTERN = Pattern.compile("(?:(?:PR|pull request)\\s+)?(?<![\\w/#])(~?[a-zA-Z][a-zA-Z0-9_\\-]*)?/?([\\p{Alnum}][\\w\\-\\.]*)?#(?:([\\d]+)(?!#)\\b)", 2);
    private static final Pattern EXCLUDE_PATTERN = MarkupUtils.LINKS;
    private final NavBuilder navBuilder;
    private final PullRequestService pullRequestService;
    private final RepositoryService repositoryService;
    @Value(value="${markup.render.pullrequest.lookup.timeout}")
    private int lookupTimeout;

    @Autowired
    public PullRequestMarkupRenderer(NavBuilder navBuilder, PullRequestService pullRequestService, RepositoryService repositoryService) {
        this.navBuilder = navBuilder;
        this.pullRequestService = pullRequestService;
        this.repositoryService = repositoryService;
    }

    @Nonnull
    public RenderTransform process(@Nonnull CharSequence text, @Nonnull RenderContext context) {
        RenderTransform.TransformBuilder builder = RenderTransform.builder();
        Map matches = MarkupUtils.findMatches((CharSequence)text, (Pattern)PULL_REQUEST_PATTERN, (Pattern)EXCLUDE_PATTERN);
        if (matches.isEmpty()) {
            return builder.build();
        }
        Map pullRequests = this.findPullRequests(matches, (Integer)context.getData().get("repositoryId"));
        for (Map.Entry entry : pullRequests.entrySet()) {
            String linkText = (String)entry.getKey();
            PullRequest pullRequest = (PullRequest)entry.getValue();
            String link = this.createLink(linkText, pullRequest, context);
            Collection matchResults = (Collection)matches.get(linkText.toLowerCase());
            for (MatchResult match : matchResults) {
                builder.add(match.start(), match.end(), link);
            }
        }
        return builder.build();
    }

    private Map<String, PullRequest> findPullRequests(Map<String, Collection<MatchResult>> pullRequestMatches, Integer contextRepositoryId) {
        HashMap<String, PullRequest> m = new HashMap<String, PullRequest>(pullRequestMatches.size(), 1.0f);
        Optional<Object> currentProject = null;
        long startTime = System.currentTimeMillis();
        for (Collection<MatchResult> pullRequestMatch : pullRequestMatches.values()) {
            long runTime;
            MatchResult match = pullRequestMatch.iterator().next();
            int repositoryId = -1;
            try {
                PullRequest pullRequest;
                String key;
                long pullRequestId = Long.parseLong(match.group(3));
                String maybeProject = match.group(1);
                String maybeRepo = match.group(2);
                if (maybeProject == null && maybeRepo == null && contextRepositoryId != null) {
                    repositoryId = contextRepositoryId;
                } else if (maybeProject != null && maybeRepo != null) {
                    Repository repo = this.repositoryService.getBySlug(maybeProject, maybeRepo);
                    if (repo != null) {
                        repositoryId = repo.getId();
                    }
                } else if (contextRepositoryId != null && (key = (String)MoreObjects.firstNonNull((Object)maybeProject, (Object)maybeRepo)).matches("[\\p{Alnum}][\\w\\-\\.]*")) {
                    Repository repo;
                    if (currentProject == null) {
                        Repository contextRepository = this.repositoryService.getById(contextRepositoryId.intValue());
                        currentProject = contextRepository == null ? Optional.empty() : Optional.of(contextRepository.getProject());
                    }
                    if (currentProject.isPresent() && (repo = this.repositoryService.getBySlug(((Project)currentProject.get()).getKey(), key)) != null) {
                        repositoryId = repo.getId();
                    }
                    if (repositoryId == -1 && key.equalsIgnoreCase("PR")) {
                        repositoryId = contextRepositoryId;
                    }
                }
                if (repositoryId != -1 && (pullRequest = this.pullRequestService.getById(repositoryId, pullRequestId)) != null) {
                    m.put(match.group(), pullRequest);
                }
            }
            catch (NumberFormatException ex) {
                log.debug("Couldn't parse pullRequestId", (Throwable)ex);
            }
            catch (AuthorisationException ex) {
                log.debug("AuthorisationException when finding PullRequest", (Throwable)ex);
            }
            if ((runTime = System.currentTimeMillis() - startTime) <= (long)this.lookupTimeout) continue;
            log.debug("{}ms timeout exceeded - spent {}ms looking up pull requests", (Object)this.lookupTimeout, (Object)runTime);
            break;
        }
        return m;
    }

    private String createLink(String pullRequestId, PullRequest pullRequest, RenderContext context) {
        Repository repository = pullRequest.getToRef().getRepository();
        String url = context.createHostUrl(this.navBuilder.repo(repository).pullRequest(pullRequest.getId()).buildRelNoContext());
        String title = pullRequest.getTitle();
        return "<a href=\"" + url + "\" class=\"pull-request\" title=\"" + StringEscapeUtils.escapeHtml4((String)title) + "\">" + StringEscapeUtils.escapeHtml4((String)pullRequestId) + "</a>";
    }
}

