/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.markup;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.idx.CommitIndex;
import com.atlassian.bitbucket.idx.IndexSearchRequest;
import com.atlassian.bitbucket.idx.IndexedCommit;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.MarkupUtils;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.markup.renderer.MarkupRendererComponent;
import com.atlassian.markup.renderer.RenderContext;
import com.atlassian.markup.renderer.RenderTransform;
import com.atlassian.stash.internal.spring.SpringTransactionUtils;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.TransactionTemplate;

@Component(value="commitMarkupRenderer")
public class CommitMarkupRenderer
implements MarkupRendererComponent {
    private static final Logger log = LoggerFactory.getLogger(CommitMarkupRenderer.class);
    private static final Pattern COMMIT_ID_PATTERN = Pattern.compile("\\b[0-9a-fA-F]{7,40}\\b");
    private static final Pattern EXCLUDE_PATTERN = MarkupUtils.LINKS;
    private static final TransactionDefinition READ_ONLY_TRANSACTION = SpringTransactionUtils.definitionFor((int)0, (boolean)true);
    private final CommitIndex commitIndex;
    private final I18nService i18nService;
    private final NavBuilder navBuilder;
    private final TransactionTemplate transactionTemplate;
    @Value(value="${markup.render.commit.lookup.timeout}")
    private int lookupTimeout;

    @Autowired
    public CommitMarkupRenderer(CommitIndex commitIndex, I18nService i18nService, NavBuilder navBuilder, PlatformTransactionManager transactionManager) {
        this(commitIndex, i18nService, navBuilder, new TransactionTemplate(transactionManager, READ_ONLY_TRANSACTION));
    }

    protected CommitMarkupRenderer(CommitIndex commitIndex, I18nService i18nService, NavBuilder navBuilder, TransactionTemplate transactionTemplate) {
        this.commitIndex = commitIndex;
        this.i18nService = i18nService;
        this.navBuilder = navBuilder;
        this.transactionTemplate = transactionTemplate;
    }

    @Nonnull
    public RenderTransform process(@Nonnull CharSequence text, @Nonnull RenderContext context) {
        RenderTransform.TransformBuilder builder = RenderTransform.builder();
        Map matches = MarkupUtils.findMatches((CharSequence)text, (Pattern)COMMIT_ID_PATTERN, (Pattern)EXCLUDE_PATTERN);
        if (matches.isEmpty()) {
            return builder.build();
        }
        Map repositories = context.getData().get("repositoryId") instanceof Integer ? this.findRepositories(matches.keySet(), ((Integer)context.getData().get("repositoryId")).intValue()) : this.findRepositories(matches.keySet());
        for (Map.Entry entry : repositories.entrySet()) {
            String commitId = (String)entry.getKey();
            Repository repository = (Repository)entry.getValue();
            String link = this.createLink(commitId, repository, context);
            Collection matchResults = (Collection)matches.get(commitId);
            for (MatchResult match : matchResults) {
                builder.add(match.start(), match.end(), link);
            }
        }
        return builder.build();
    }

    private String createLink(String commitId, Repository repository, RenderContext context) {
        String url = context.createHostUrl(this.navBuilder.repo(repository).commit(commitId).buildRelNoContext());
        String title = this.i18nService.getMessage("bitbucket.web.markup.commit.tooltip", new Object[]{repository.getName(), repository.getProject().getName()});
        return "<a href=\"" + StringEscapeUtils.escapeHtml4((String)url) + "\" class=\"commitid\" title=\"" + StringEscapeUtils.escapeHtml4((String)title) + "\">" + StringEscapeUtils.escapeHtml4((String)commitId) + "</a>";
    }

    private Map<String, Repository> findRepositories(Set<String> commitIds) {
        return this.findRepositories(commitIds, -1);
    }

    private Map<String, Repository> findRepositories(Set<String> commitIds, int sourceRepositoryId) {
        return (Map)this.transactionTemplate.execute(status -> {
            HashMap m = Maps.newHashMap();
            long startTime = System.currentTimeMillis();
            for (String commitId : commitIds) {
                long runTime;
                Page commits = this.commitIndex.search(new IndexSearchRequest.Builder().prefix(commitId).build(), PageUtils.newRequest((int)0, (int)2));
                if (commits.getSize() == 1) {
                    IndexedCommit commit = (IndexedCommit)Iterables.getOnlyElement((Iterable)commits.getValues());
                    Set repositories = commit.getRepositories();
                    repositories.stream().filter(repository -> sourceRepositoryId < 0 || repository.getId() == sourceRepositoryId).findFirst().ifPresent(repository -> m.put(commitId, repository));
                }
                if ((runTime = System.currentTimeMillis() - startTime) <= (long)this.lookupTimeout) continue;
                log.debug("{}ms timeout exceeded - spent {}ms looking up commits", (Object)this.lookupTimeout, (Object)runTime);
                break;
            }
            return m;
        });
    }
}

