/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.integrity;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.stash.internal.integrity.IntegrityCheckEventService;
import com.atlassian.stash.internal.integrity.IntegrityCheckService;
import com.atlassian.stash.internal.integrity.PullRequestIntegrityCheckRequest;
import com.atlassian.stash.internal.web.auth.IgnoresXsrf;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"/admin/integrity-check"})
public class IntegrityJobController {
    private final IntegrityCheckEventService checkEventService;
    private final IntegrityCheckService checkService;

    @Autowired
    public IntegrityJobController(IntegrityCheckEventService checkEventService, IntegrityCheckService checkService) {
        this.checkEventService = checkEventService;
        this.checkService = checkService;
    }

    @IgnoresXsrf
    @RequestMapping(method={RequestMethod.POST}, value={"/acknowledge"}, consumes={"application/json"}, produces={"application/json"})
    public ResponseEntity acknowledgeBanner() {
        this.checkEventService.markCheckResultAcknowledged();
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    @IgnoresXsrf
    @RequestMapping(method={RequestMethod.POST}, value={"/repositories"}, consumes={"application/json"}, produces={"application/json"})
    public ResponseEntity<Map<String, Object>> checkRepositories() {
        Map inconsistencyReport = (Map)IntegrityJobController.toStream((Map)this.checkService.checkRepositories()).map(IntegrityJobController::toDetails).collect(IntegrityJobController.toReport());
        return new ResponseEntity((Object)inconsistencyReport, HttpStatus.OK);
    }

    @IgnoresXsrf
    @RequestMapping(method={RequestMethod.POST}, value={"/merged-pull-requests"})
    public ResponseEntity<Map<String, Object>> merged(@RequestParam(value="days", required=false, defaultValue="7") int updatedWithinDays) {
        PullRequestIntegrityCheckRequest checkRequest = new PullRequestIntegrityCheckRequest.Builder().activityWindow((long)updatedWithinDays, TimeUnit.DAYS).build();
        List inconsistentPullRequests = this.checkService.checkMergedPullRequests(checkRequest).stream().map(mergeActivity -> ImmutableMap.of((Object)"pullRequest", (Object)ImmutableMap.of((Object)"id", (Object)mergeActivity.getPullRequestId(), (Object)"project", (Object)mergeActivity.getToRef().getRepository().getProject().getKey(), (Object)"repository", (Object)mergeActivity.getToRef().getRepository().getSlug()))).collect(Collectors.toList());
        return new ResponseEntity((Object)ImmutableMap.of((Object)"inconsistencies", inconsistentPullRequests, (Object)"total", (Object)inconsistentPullRequests.size()), HttpStatus.OK);
    }

    @IgnoresXsrf
    @RequestMapping(method={RequestMethod.POST}, value={"/open-pull-requests"}, consumes={"application/json"}, produces={"application/json"})
    public ResponseEntity<String> open() {
        this.checkService.scheduleOpenPullRequestChecksByRescope(new PullRequestIntegrityCheckRequest.Builder().build());
        return new ResponseEntity(HttpStatus.ACCEPTED);
    }

    private static Map<String, Object> toDetails(Map.Entry<Repository, List<String>> inconsistencies) {
        return ImmutableMap.of((Object)"id", (Object)inconsistencies.getKey().getId(), (Object)"project", (Object)inconsistencies.getKey().getProject().getId(), (Object)"slug", (Object)inconsistencies.getKey().getSlug(), (Object)"messages", inconsistencies.getValue());
    }

    private static Collector<Map<String, Object>, ?, Map<String, Object>> toReport() {
        return Collectors.collectingAndThen(Collectors.toList(), repositoryDetail -> ImmutableMap.of((Object)"inconsistencies", (Object)repositoryDetail, (Object)"total", (Object)repositoryDetail.size()));
    }

    private static Stream<Map.Entry<Repository, List<String>>> toStream(Map<Repository, List<String>> map) {
        return map.entrySet().stream();
    }
}

