/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.http;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.http.HttpScmProtocol;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.ContextProvider;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public class HttpCloneUrlContextProvider
implements ContextProvider {
    private final AuthenticationContext authenticationContext;
    private final HttpScmProtocol protocol;

    public HttpCloneUrlContextProvider(AuthenticationContext authenticationContext, HttpScmProtocol protocol) {
        this.authenticationContext = authenticationContext;
        this.protocol = protocol;
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        Repository repository = (Repository)context.get("repository");
        String cloneUrl = this.protocol.getCloneUrl(repository, this.authenticationContext.getCurrentUser());
        return ImmutableMap.of((Object)"cloneUrl", (Object)MoreObjects.firstNonNull((Object)cloneUrl, (Object)"Unavailable"));
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }
}

