/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.help;

import com.atlassian.bitbucket.help.HelpPathService;
import com.atlassian.plugin.servlet.DownloadableResource;
import com.atlassian.plugin.webresource.QueryParams;
import com.atlassian.plugin.webresource.transformer.TransformableResource;
import com.atlassian.plugin.webresource.transformer.TransformerParameters;
import com.atlassian.plugin.webresource.transformer.TransformerUrlBuilder;
import com.atlassian.plugin.webresource.transformer.UrlReadingWebResourceTransformer;
import com.atlassian.plugin.webresource.transformer.WebResourceTransformerFactory;
import com.atlassian.plugin.webresource.url.UrlBuilder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;

public class JavascriptHelpUrlWebResourceTransformer
implements WebResourceTransformerFactory,
TransformerUrlBuilder,
UrlReadingWebResourceTransformer {
    private static final Pattern PATTERN = Pattern.compile("bitbucket_help_url\\(\\s*(['\"])([\\w.-]+)\\1\\s*\\)");
    private final HelpPathService helpPathService;

    public JavascriptHelpUrlWebResourceTransformer(HelpPathService helpPathService) {
        this.helpPathService = helpPathService;
    }

    public TransformerUrlBuilder makeUrlBuilder(TransformerParameters parameters) {
        return this;
    }

    public UrlReadingWebResourceTransformer makeResourceTransformer(TransformerParameters parameters) {
        return this;
    }

    public void addToUrl(UrlBuilder urlBuilder) {
    }

    public DownloadableResource transform(TransformableResource transformableResource, QueryParams params) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    protected String doTransform(CharSequence originalContent) {
        Matcher matcher = PATTERN.matcher(originalContent);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            String helpPageUrl = this.helpPathService.getPageUrl(matcher.group(2));
            matcher.appendReplacement(result, "");
            result.append("'").append(StringEscapeUtils.escapeEcmaScript((String)(helpPageUrl == null ? "" : helpPageUrl))).append("'");
        }
        matcher.appendTail(result);
        return result.toString();
    }
}

