/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.fragments;

import com.atlassian.bitbucket.pull.PullRequestSearchRequest;
import com.atlassian.bitbucket.pull.PullRequestService;
import com.atlassian.bitbucket.pull.PullRequestState;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.ContextProvider;
import com.google.common.collect.ImmutableMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class PullRequestCountContextProvider
implements ContextProvider {
    public static final String REPOSITORY = "repository";
    private final PullRequestService pullRequestService;
    private PullRequestState state;

    public PullRequestCountContextProvider(PullRequestService pullRequestService) {
        this.pullRequestService = pullRequestService;
    }

    public void init(Map<String, String> params) throws PluginParseException {
        String stateStr = params.get("state");
        if (stateStr == null) {
            throw new PluginParseException("<param name=\"state\">{state_name}</param> is required. Valid state_names are " + this.getAllowedStateValuesString());
        }
        try {
            this.state = PullRequestState.valueOf((String)stateStr);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (this.state == null) {
            throw new PluginParseException("The value of param 'state' was not a valid PullRequestState. Valid values are " + this.getAllowedStateValuesString());
        }
    }

    private String getAllowedStateValuesString() {
        return StringUtils.join((Object[])PullRequestState.values(), (String)", ");
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        Repository repository = (Repository)context.get(REPOSITORY);
        long count = this.pullRequestService.count(new PullRequestSearchRequest.Builder().toRepositoryId(Integer.valueOf(repository.getId())).state(this.state).build());
        return ImmutableMap.of((Object)"state", (Object)this.state.name().toLowerCase(Locale.US), (Object)"count", (Object)count);
    }
}

