/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.fragments;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.watcher.IsWatchingRequest;
import com.atlassian.bitbucket.watcher.Watchable;
import com.atlassian.bitbucket.watcher.WatcherService;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.ContextProvider;
import com.atlassian.stash.internal.watcher.InternalWatchable;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

public class IsWatchingContextProvider
implements ContextProvider {
    private final AuthenticationContext authenticationContext;
    private final WatcherService watcherService;

    public IsWatchingContextProvider(AuthenticationContext authenticationContext, WatcherService watcherService) {
        this.authenticationContext = authenticationContext;
        this.watcherService = watcherService;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        boolean isWatching = false;
        ApplicationUser currentUser = this.authenticationContext.getCurrentUser();
        if (currentUser != null) {
            Commit commit;
            InternalWatchable watchable = (InternalWatchable)context.get("watchable");
            isWatching = watchable != null ? this.watcherService.isWatching(new IsWatchingRequest.Builder((Watchable)watchable).build()) : (commit = (Commit)context.get("commit")) != null && Objects.equals(currentUser.getEmailAddress(), commit.getAuthor().getEmailAddress());
        }
        return ImmutableMap.of((Object)"isWatching", (Object)isWatching);
    }
}

