/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.filters;

import com.atlassian.bitbucket.project.PersonalProject;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.bitbucket.user.UserType;
import com.atlassian.bitbucket.util.NumberUtils;
import com.atlassian.stash.internal.project.InternalPersonalProject;
import com.atlassian.stash.internal.project.InternalProjectService;
import com.atlassian.stash.internal.web.soy.StashSoyResponseBuilder;
import com.opensymphony.sitemesh.Content;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class SiteMeshDataContributor {
    private static final Logger log = LoggerFactory.getLogger(SiteMeshDataContributor.class);
    private final InternalProjectService projectService;
    private final PullRequestService pullRequestService;
    private final RepositoryService repositoryService;
    private final UserService userService;
    @Value(value="${page.max.changes}")
    private int maxChanges;

    @Autowired
    public SiteMeshDataContributor(InternalProjectService projectService, PullRequestService pullRequestService, RepositoryService repositoryService, UserService userService) {
        this.projectService = projectService;
        this.pullRequestService = pullRequestService;
        this.repositoryService = repositoryService;
        this.userService = userService;
    }

    public void contribute(Content content, StashSoyResponseBuilder dataBuilder) {
        String connectHostUrl = content.getProperty("meta.connectHostUrl");
        String projectKey = content.getProperty("meta.projectKey");
        String repoSlug = content.getProperty("meta.repositorySlug");
        String pullRequestId = content.getProperty("meta.pullRequestId");
        Integer userId = NumberUtils.parse((String)content.getProperty("meta.userId"), null, null);
        String userSlug = content.getProperty("meta.userSlug");
        if (connectHostUrl != null) {
            dataBuilder.put("connectHostUrl", (Object)connectHostUrl);
        }
        ApplicationUser user = null;
        if (userId != null) {
            user = this.userService.getUserById(userId.intValue());
        } else if (StringUtils.isNotEmpty((CharSequence)userSlug)) {
            user = this.userService.getUserBySlug(userSlug);
        }
        if (user != null) {
            dataBuilder.put("user", (Object)user);
            if (user.getType() == UserType.NORMAL) {
                String userProjectKey = InternalPersonalProject.createPersonalProjectKey((ApplicationUser)user);
                if (projectKey != null && !userProjectKey.equalsIgnoreCase(projectKey)) {
                    log.warn("Both userSlug and projectKey were specified to the decorator, user's personal project {} is going to stomp {}", (Object)userProjectKey, (Object)projectKey);
                }
                PersonalProject project = this.projectService.getPersonalProject(user);
                dataBuilder.putProject((Project)project);
            }
        } else if (!StringUtils.isEmpty((CharSequence)projectKey)) {
            Project project = null;
            if (!StringUtils.isEmpty((CharSequence)repoSlug)) {
                Repository repo = this.repositoryService.getBySlug(projectKey, repoSlug);
                if (repo != null) {
                    project = repo.getProject();
                    if (!StringUtils.isEmpty((CharSequence)pullRequestId)) {
                        PullRequest pullRequest = this.pullRequestService.getById(repo.getId(), Long.parseLong(pullRequestId));
                        if (pullRequest != null) {
                            dataBuilder.putPullRequest(pullRequest);
                        }
                        dataBuilder.put("maxChanges", (Object)this.maxChanges);
                    }
                    dataBuilder.putRepository(repo);
                }
            } else {
                project = this.projectService.getByKey(projectKey);
            }
            if (project != null) {
                dataBuilder.putProject(project);
            }
        }
    }
}

