/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.filters;

import com.atlassian.bitbucket.request.RequestContext;
import com.atlassian.bitbucket.request.RequestManager;
import com.atlassian.stash.internal.web.HttpRequestInfoHelper;
import com.atlassian.stash.internal.web.util.web.CountingHttpServletRequestWrapper;
import com.atlassian.stash.internal.web.util.web.CountingHttpServletResponseWrapper;
import java.io.IOException;
import javax.servlet.AsyncListener;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

/*
 * Exception performing whole class analysis ignored.
 */
@Component(value="requestAttributeFilter")
public class RequestAttributeFilter
extends OncePerRequestFilter {
    public static final String ATTR_RAW_URI = "bbs.raw.request.uri";
    public static final String HDR_X_AREQUESTID = "X-AREQUESTID";
    public static final String HDR_X_ASESSIONID = "X-ASESSIONID";
    private final HttpRequestInfoHelper helper;
    private final RequestManager requestManager;

    @Autowired
    public RequestAttributeFilter(HttpRequestInfoHelper helper, RequestManager requestManager) {
        this.helper = helper;
        this.requestManager = requestManager;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        request.setAttribute("bbs.raw.request.uri", (Object)request.getRequestURI());
        try {
            this.requestManager.doAsRequest(requestContext -> {
                response.setHeader("X-AREQUESTID", requestContext.getId());
                if (requestContext.hasSessionId()) {
                    response.setHeader("X-ASESSIONID", requestContext.getSessionId());
                }
                CountingHttpServletRequestWrapper requestWrapper = new CountingHttpServletRequestWrapper(request);
                CountingHttpServletResponseWrapper responseWrapper = new CountingHttpServletResponseWrapper(response);
                filterChain.doFilter((ServletRequest)requestWrapper, (ServletResponse)responseWrapper);
                if (request.isAsyncStarted()) {
                    request.getAsyncContext().addListener((AsyncListener)new /* Unavailable Anonymous Inner Class!! */);
                } else {
                    RequestAttributeFilter.summarize((RequestContext)requestContext, (CountingHttpServletRequestWrapper)requestWrapper, (CountingHttpServletResponseWrapper)responseWrapper);
                }
                return null;
            }, this.helper.createRequestInfoProvider(request, response));
        }
        catch (IOException | RuntimeException | ServletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServletException("Unexpected exception handling request", (Throwable)e);
        }
    }

    protected boolean shouldNotFilterErrorDispatch() {
        return false;
    }

    private static void summarize(RequestContext requestContext, CountingHttpServletRequestWrapper request, CountingHttpServletResponseWrapper response) throws IOException {
        response.flushBuffer();
        requestContext.setBytesRead(request.getBytesRead());
        requestContext.setBytesWritten(response.getBytesWritten());
        requestContext.setResponseCode(response.getStatus());
    }

    static /* synthetic */ void access$000(RequestContext x0, CountingHttpServletRequestWrapper x1, CountingHttpServletResponseWrapper x2) throws IOException {
        RequestAttributeFilter.summarize((RequestContext)x0, (CountingHttpServletRequestWrapper)x1, (CountingHttpServletResponseWrapper)x2);
    }
}

