/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.filters;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.dmz.request.DmzRequestContext;
import com.atlassian.bitbucket.request.RequestManager;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.stash.internal.web.HttpRequestInfoHelper;
import com.atlassian.stash.internal.web.util.CachePolicies;
import com.atlassian.stash.internal.web.util.UriEncodingUtils;
import java.io.IOException;
import java.net.URISyntaxException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

@Component(value="authenticationAttributeFilter")
public class AuthenticationAttributeFilter
extends OncePerRequestFilter {
    static final String X_AUSERNAME = "X-AUSERNAME";
    static final String X_AUSERID = "X-AUSERID";
    private final AuthenticationContext authenticationContext;
    private final HttpRequestInfoHelper helper;
    private final RequestManager requestManager;

    @Autowired
    public AuthenticationAttributeFilter(AuthenticationContext authenticationContext, HttpRequestInfoHelper helper, RequestManager requestManager) {
        this.authenticationContext = authenticationContext;
        this.helper = helper;
        this.requestManager = requestManager;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String sessionId;
        ApplicationUser user = this.authenticationContext.getCurrentUser();
        if (user != null) {
            response.setHeader(X_AUSERID, String.valueOf(user.getId()));
            try {
                response.setHeader(X_AUSERNAME, UriEncodingUtils.encodeURIComponent((String)user.getName(), (String)"UTF-8"));
            }
            catch (URISyntaxException e) {
                throw new ServletException("Unable to encode the username", (Throwable)e);
            }
            MDC.put((String)"a-username", (String)user.getName());
            DmzRequestContext requestContext = (DmzRequestContext)this.requestManager.getRequestContext();
            requestContext.setAuthenticatedUser(user);
        }
        if ((sessionId = this.helper.getSessionId(request)) != null) {
            if (!response.containsHeader("X-ASESSIONID")) {
                response.setHeader("X-ASESSIONID", sessionId);
            }
            MDC.put((String)"a-session-id", (String)sessionId);
        }
        if (response.containsHeader("Set-Cookie")) {
            CachePolicies.setCacheControlNoCache((HttpServletResponse)response);
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

