/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.auth;

import com.atlassian.bitbucket.ServiceException;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.auth.RememberMeMode;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.util.UrlUtils;
import com.atlassian.stash.internal.auth.AuthenticationHelper;
import com.google.common.collect.ImmutableMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.authentication.LockedException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

/*
 * Exception performing whole class analysis ignored.
 */
@Controller
@RequestMapping(value={"/login"})
public class LoginController {
    public static final String LOGIN = "bitbucket.internal.page.login.login.login";
    public static final String LOGIN_EMBEDDED = "bitbucket.internal.page.login.login.loginEmbedded";
    private static final Logger log = LoggerFactory.getLogger(LoginController.class);
    private final AuthenticationContext authenticationContext;
    private final AuthenticationHelper authenticationHelper;
    private final I18nService i18nService;
    private final NavBuilder navBuilder;
    private final PermissionService permissionService;
    private final ApplicationPropertiesService propertiesService;
    private final boolean showRememberMe;

    @Autowired
    public LoginController(AuthenticationContext authenticationContext, AuthenticationHelper authenticationHelper, I18nService i18nService, NavBuilder navBuilder, PermissionService permissionService, ApplicationPropertiesService propertiesService, @Value(value="${auth.remember-me.enabled}") String rememberMeMode) {
        this.authenticationContext = authenticationContext;
        this.authenticationHelper = authenticationHelper;
        this.i18nService = i18nService;
        this.navBuilder = navBuilder;
        this.permissionService = permissionService;
        this.propertiesService = propertiesService;
        this.showRememberMe = RememberMeMode.fromId((String)rememberMeMode) == RememberMeMode.OPTIONAL;
    }

    @RequestMapping(method={RequestMethod.GET})
    public ModelAndView login(@RequestParam(value="next", required=false) String nextUrl, @RequestParam(value="permission", required=false) String requiredPermission, @RequestParam(value="embedded", required=false) boolean embedded, HttpServletRequest request) {
        Permission permission = this.parsePermission(requiredPermission);
        ModelAndView redirect = this.redirectIfAuthenticated(nextUrl, permission);
        if (redirect != null) {
            return redirect;
        }
        return new ModelAndView(LoginController.loginTemplate((boolean)embedded), this.buildContext(nextUrl, permission, request));
    }

    private static String loginTemplate(boolean embedded) {
        return embedded ? "bitbucket.internal.page.login.login.loginEmbedded" : "bitbucket.internal.page.login.login.login";
    }

    private void addRequiredPermission(ImmutableMap.Builder<String, Object> builder, Permission requiredPermission) {
        if (requiredPermission == null) {
            return;
        }
        builder.put((Object)"permission", (Object)requiredPermission.name());
        builder.put((Object)"warning", (Object)this.i18nService.getText("bitbucket.web.login.permission.required", "Please log in as a user with the '{0}' permission to access this resource.", new Object[]{this.i18nService.getMessage(requiredPermission.getI18n().name())}));
    }

    private Map<String, Object> buildContext(String nextUrl, Permission requiredPermission, HttpServletRequest request) {
        String lastUsername;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        AuthenticationException authenticationException = this.authenticationHelper.getAuthenticationException(request);
        if (authenticationException != null) {
            if (authenticationException.getCause() instanceof ServiceException) {
                builder.put((Object)"error", (Object)authenticationException.getCause().getLocalizedMessage());
            } else {
                builder.put((Object)"error", (Object)authenticationException.getLocalizedMessage());
                log.warn("Authentication failed with an unexpected error type", (Throwable)authenticationException);
            }
            this.authenticationHelper.setAuthenticationException(request, null);
        }
        if (StringUtils.isNotEmpty((CharSequence)(lastUsername = this.authenticationHelper.getCachedUsername(request)))) {
            builder.put((Object)"lastUsername", (Object)lastUsername);
        }
        builder.put((Object)"allowSignUp", (Object)this.propertiesService.isAllowPublicSignUp());
        builder.put((Object)"showCaptcha", (Object)(authenticationException instanceof LockedException));
        if (StringUtils.isNotEmpty((CharSequence)nextUrl)) {
            builder.put((Object)"nextUrl", (Object)UrlUtils.safeUrlForRedirect((String)nextUrl, (String)this.navBuilder.buildAbsolute(), (String)this.navBuilder.buildAbsolute()));
        }
        builder.put((Object)"showRememberMe", (Object)this.showRememberMe);
        this.addRequiredPermission(builder, requiredPermission);
        if (StringUtils.isNotBlank((CharSequence)request.getQueryString())) {
            builder.put((Object)"queryString", (Object)request.getQueryString());
        }
        return builder.build();
    }

    private boolean hasRequiredPermission(Permission requiredPermission) {
        return requiredPermission == null || this.permissionService.hasGlobalPermission(requiredPermission);
    }

    private Permission parsePermission(String requiredPermission) {
        if (requiredPermission == null) {
            return null;
        }
        String permissionName = requiredPermission.toUpperCase(Locale.ENGLISH);
        if (Permission.ADMIN.name().equals(permissionName)) {
            return Permission.ADMIN;
        }
        if (Permission.SYS_ADMIN.name().equals(permissionName)) {
            return Permission.SYS_ADMIN;
        }
        log.warn("Unsupported permission name passed as permission: {}, ignoring", (Object)requiredPermission);
        return null;
    }

    private ModelAndView redirectIfAuthenticated(String nextUrl, Permission minimumPermission) {
        if (this.authenticationContext.isAuthenticated() && this.hasRequiredPermission(minimumPermission)) {
            if (StringUtils.isNotBlank((CharSequence)nextUrl)) {
                return new ModelAndView((View)new RedirectView(UrlUtils.safeUrlForRedirect((String)nextUrl, (String)(this.navBuilder.buildAbsolute() + "/"), (String)this.navBuilder.buildAbsolute()), true));
            }
            return new ModelAndView((View)new RedirectView(this.navBuilder.buildAbsolute()));
        }
        return null;
    }
}

