/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.admin;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionAdminService;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.project.ProjectService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.stash.internal.web.admin.BasePermissionController;
import com.atlassian.stash.internal.web.soy.StashSoyResponseBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/projects/{projectKey}/repos/{repoSlug}/permissions"})
public class RepositoryPermissionsController
extends BasePermissionController {
    public static final String REPOSITORY_EDIT_PERMISSIONS = "bitbucket.internal.page.repository.permissions.repositoryPermissions.repositoryPermissions";
    private final RepositoryService repositoryService;
    private final ProjectService projectService;
    private final PermissionValidationService permissionValidationService;
    private final PermissionService permissionService;
    private final NavBuilder navBuilder;

    @Autowired
    public RepositoryPermissionsController(PermissionAdminService permissionAdminService, I18nService i18nService, RepositoryService repositoryService, ProjectService projectService, PermissionValidationService permissionValidationService, PermissionService permissionService, NavBuilder navBuilder) {
        super(permissionAdminService, i18nService);
        this.repositoryService = repositoryService;
        this.projectService = projectService;
        this.permissionValidationService = permissionValidationService;
        this.permissionService = permissionService;
        this.navBuilder = navBuilder;
    }

    @RequestMapping(method={RequestMethod.GET})
    public ModelAndView editRepositoryPermissions(@PathVariable(value="projectKey") String projectKey, @PathVariable(value="repoSlug") String repoSlug) {
        Repository repository = this.repositoryService.getBySlug(projectKey, repoSlug);
        if (repository == null) {
            Project project = this.projectService.getByKey(projectKey);
            if (project == null) {
                throw this.newNoSuchProjectException(projectKey);
            }
            throw this.newNoSuchRepositoryException(project, repoSlug);
        }
        this.permissionValidationService.validateForRepository(repository, Permission.REPO_ADMIN);
        return ((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)new StashSoyResponseBuilder(REPOSITORY_EDIT_PERMISSIONS).put("repository", (Object)repository)).put("projectPermissionUrl", (Object)this.getProjectPermissionUrlIfAdmin(repository.getProject()))).put("permissionDataList", (Object)this.getPermissionData(new Permission[]{Permission.REPO_ADMIN, Permission.REPO_WRITE, Permission.REPO_READ}))).build();
    }

    private String getProjectPermissionUrlIfAdmin(Project project) {
        if (this.permissionService.hasProjectPermission(project, Permission.PROJECT_ADMIN)) {
            return this.navBuilder.project(project).permissions().buildRelative();
        }
        return null;
    }
}

