/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.admin;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionAdminService;
import com.atlassian.stash.internal.web.util.ControllerSupport;
import com.atlassian.stash.internal.web.widgets.permissions.PermissionData;
import java.util.ArrayList;
import java.util.List;

abstract class BasePermissionController
extends ControllerSupport {
    protected static final String GLOBAL_PERMISSIONS = "bitbucket.internal.page.admin.globalPermissions.globalPermissions.globalPermissions";
    protected final PermissionAdminService permissionAdminService;
    protected final I18nService i18nService;

    public BasePermissionController(PermissionAdminService permissionAdminService, I18nService i18nService) {
        super(i18nService);
        this.permissionAdminService = permissionAdminService;
        this.i18nService = i18nService;
    }

    protected List<PermissionData> getPermissionData(Permission ... permissions) {
        ArrayList<PermissionData> permissionDataList = new ArrayList<PermissionData>(permissions.length);
        for (Permission globalPermission : permissions) {
            String permissionName = this.i18nService.getMessage(globalPermission.getI18n().shortName());
            String permissionDescription = this.i18nService.getMessage(globalPermission.getI18n().description());
            permissionDataList.add(new PermissionData(globalPermission, permissionName, permissionDescription));
        }
        return permissionDataList;
    }
}

