/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.admin;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.stash.internal.avatar.InternalAvatarService;
import com.atlassian.stash.internal.web.admin.AvatarController;
import com.atlassian.stash.internal.web.soy.StashSoyResponseBuilder;
import com.atlassian.stash.internal.web.util.ControllerSupport;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.Errors;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/admin/avatars"})
public class AvatarController
extends ControllerSupport {
    private static final String VIEW = "bitbucket.internal.page.admin.avatarsettings.avatarsettings";
    private static final String REDIRECT_URL = "redirect:/admin/avatars";
    private final InternalAvatarService avatarService;

    @Autowired
    public AvatarController(I18nService i18nService, InternalAvatarService avatarService) {
        super(i18nService);
        this.avatarService = avatarService;
    }

    @RequestMapping(method={RequestMethod.GET})
    public ModelAndView view() {
        return ((StashSoyResponseBuilder)new StashSoyResponseBuilder(VIEW).put("settings", (Object)this.loadSettings())).build();
    }

    @RequestMapping(method={RequestMethod.POST})
    public ModelAndView update(@Validated Form form, Errors errors, RedirectAttributes redirectAttributes) {
        if (errors.hasErrors()) {
            return ((StashSoyResponseBuilder)new StashSoyResponseBuilder(VIEW).put("settings", (Object)this.loadSettings())).putValidationErrors(errors).build();
        }
        this.avatarService.setEnabled(form.isEnableGravatar());
        redirectAttributes.addFlashAttribute("saved", (Object)true);
        return new StashSoyResponseBuilder(REDIRECT_URL).build();
    }

    private Form loadSettings() {
        return new Form(this.avatarService.isEnabled());
    }
}

