/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web;

import com.atlassian.bitbucket.internal.boot.web.BitbucketServerInitializer;
import com.atlassian.bitbucket.server.ApplicationState;
import com.atlassian.bitbucket.server.ApplicationStatusService;
import com.atlassian.stash.internal.lifecycle.StartupManager;
import com.atlassian.stash.internal.web.ApplicationStatusServlet;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class ApplicationStatusServlet
extends HttpServlet {
    public static final Set<String> ALLOWED_METHODS = ImmutableSet.of((Object)"GET", (Object)"HEAD", (Object)"OPTIONS");
    public static final String URL_PATTERN = "/status";
    private static final Logger log = LoggerFactory.getLogger(ApplicationStatusServlet.class);
    private final StartupManager startupManager;
    private volatile ApplicationStatusService applicationStatusService;

    public ApplicationStatusServlet(StartupManager startupManager) {
        this.startupManager = startupManager;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        ApplicationState state = this.prepareResponse(req, resp);
        resp.setContentType("application/json");
        resp.getWriter().append("{\"state\":\"").append(state.name()).append("\"}");
    }

    protected void doHead(HttpServletRequest req, HttpServletResponse resp) {
        this.prepareResponse(req, resp);
    }

    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) {
        this.prepareResponse(req, resp);
        resp.setHeader("Access-Control-Allow-Headers", "x-atlassian-mau-ignore");
        resp.setHeader("Allow", Joiner.on((String)", ").join((Iterable)ALLOWED_METHODS));
    }

    private ApplicationState getApplicationState(HttpServletRequest request) {
        WebApplicationContext context;
        if (this.applicationStatusService == null && (context = WebApplicationContextUtils.getWebApplicationContext((ServletContext)request.getServletContext(), (String)BitbucketServerInitializer.ATTR_WEB_APPLICATION_CONTEXT)) != null) {
            try {
                this.applicationStatusService = (ApplicationStatusService)context.getBean(ApplicationStatusService.class);
            }
            catch (BeansException e) {
                log.debug("Could not obtain ApplicationStatusService from Spring context ({})", (Object)e.getMessage());
            }
        }
        if (this.applicationStatusService != null) {
            return this.applicationStatusService.getState();
        }
        if (this.startupManager.isStarting()) {
            return ApplicationState.STARTING;
        }
        return ApplicationState.ERROR;
    }

    private int mapStateToHttpStatusCode(ApplicationState state) {
        switch (1.$SwitchMap$com$atlassian$bitbucket$server$ApplicationState[state.ordinal()]) {
            case 1: {
                return 500;
            }
            case 2: 
            case 3: {
                return 503;
            }
        }
        return 200;
    }

    private ApplicationState prepareResponse(HttpServletRequest req, HttpServletResponse resp) {
        ApplicationState state = this.getApplicationState(req);
        resp.setStatus(this.mapStateToHttpStatusCode(state));
        resp.setHeader("Access-Control-Allow-Origin", "*");
        return state;
    }
}

