/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.spring.security;

import com.atlassian.bitbucket.auth.SimpleAuthentication;
import com.atlassian.bitbucket.permission.PermissionVoter;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.stash.internal.auth.HttpAuthUtils;
import com.atlassian.stash.internal.permission.PermissionVoterFactory;
import com.atlassian.stash.internal.spring.security.AuthenticatedUserState;
import com.atlassian.stash.internal.user.StashUserAuthenticationToken;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextImpl;
import org.springframework.security.web.context.HttpRequestResponseHolder;
import org.springframework.security.web.context.SecurityContextRepository;
import org.springframework.security.web.util.matcher.RequestMatcher;

public class HttpSessionSecurityContextRepository
implements SecurityContextRepository {
    static final String BBS_SECURITY_CONTEXT = "__bbs.security.ctx";
    private final RequestMatcher canCreateHttpSessionMatcher;
    private final UserService userService;
    private final PermissionVoterFactory voterFactory;

    public HttpSessionSecurityContextRepository(RequestMatcher canCreateHttpSessionMatcher, UserService userService, PermissionVoterFactory voterFactory) {
        this.canCreateHttpSessionMatcher = canCreateHttpSessionMatcher;
        this.userService = userService;
        this.voterFactory = voterFactory;
    }

    public void saveContext(SecurityContext context, HttpServletRequest request, HttpServletResponse response) {
        StashUserAuthenticationToken authenticationToken;
        ApplicationUser user;
        boolean createNewSession;
        HttpSession httpSession;
        Authentication authentication = context.getAuthentication();
        if (authentication == null) {
            HttpSession httpSession2 = request.getSession(false);
            if (httpSession2 != null) {
                httpSession2.removeAttribute(BBS_SECURITY_CONTEXT);
            }
        } else if (authentication instanceof StashUserAuthenticationToken && (httpSession = request.getSession(createNewSession = (user = (authenticationToken = (StashUserAuthenticationToken)authentication).getPrincipal()) != null && this.canCreateHttpSessionMatcher.matches(request) && !response.isCommitted())) != null) {
            AuthenticatedUserState state = this.getUserState(httpSession);
            if (user == null || HttpAuthUtils.isBasicAuth((HttpServletRequest)request)) {
                if (state != null) {
                    httpSession.removeAttribute(BBS_SECURITY_CONTEXT);
                }
            } else {
                AuthenticatedUserState newState = new AuthenticatedUserState(authenticationToken);
                if (!Objects.equals(newState, state)) {
                    httpSession.setAttribute(BBS_SECURITY_CONTEXT, (Object)newState);
                }
            }
        }
    }

    public SecurityContext loadContext(HttpRequestResponseHolder requestResponseHolder) {
        ApplicationUser user;
        SecurityContextImpl securityContext = new SecurityContextImpl();
        HttpServletRequest request = requestResponseHolder.getRequest();
        AuthenticatedUserState state = this.getUserState(request);
        if (state != null && (user = this.userService.getUserById(state.getUserId())) != null && user.isActive()) {
            PermissionVoter voter = this.voterFactory.create(SimpleAuthentication.builder((ApplicationUser)user).properties(state.getProperties()).build());
            StashUserAuthenticationToken authenticationToken = new StashUserAuthenticationToken.Builder().user(user).voter(voter).properties(state.getProperties()).build();
            securityContext.setAuthentication((Authentication)authenticationToken);
        }
        return securityContext;
    }

    public boolean containsContext(HttpServletRequest request) {
        return this.getUserState(request) != null;
    }

    private AuthenticatedUserState getUserState(HttpServletRequest request) {
        return this.getUserState(request.getSession(false));
    }

    private AuthenticatedUserState getUserState(HttpSession session) {
        if (session == null) {
            return null;
        }
        Object context = session.getAttribute(BBS_SECURITY_CONTEXT);
        if (context != null && !(context instanceof AuthenticatedUserState)) {
            session.removeAttribute(BBS_SECURITY_CONTEXT);
            return null;
        }
        return (AuthenticatedUserState)context;
    }
}

