/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.spring.security;

import com.atlassian.stash.internal.user.StashUserAuthenticationToken;
import com.google.common.collect.ImmutableMap;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;

public class AuthenticatedUserState
implements DataSerializable {
    private Map<String, Serializable> properties;
    private int userId;

    public AuthenticatedUserState(@Nonnull StashUserAuthenticationToken authenticationToken) {
        this.properties = Objects.requireNonNull(authenticationToken, "authenticationToken").getProperties();
        this.userId = authenticationToken.getPrincipal().getId();
    }

    public AuthenticatedUserState(int id, Map<String, Serializable> properties) {
        this.properties = properties;
        this.userId = id;
    }

    @Nonnull
    public Map<String, Serializable> getProperties() {
        return this.properties;
    }

    public int getUserId() {
        return this.userId;
    }

    public void readData(ObjectDataInput in) throws IOException {
        this.userId = in.readInt();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        int length = in.readInt();
        for (int i = 0; i < length; ++i) {
            builder.put((Object)in.readUTF(), in.readObject(Serializable.class));
        }
        this.properties = builder.build();
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.write(this.userId);
        out.write(this.properties.size());
        for (Map.Entry entry : this.properties.entrySet()) {
            out.writeUTF((String)entry.getKey());
            out.writeObject(entry.getValue());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticatedUserState that = (AuthenticatedUserState)o;
        return this.userId == that.userId && Objects.equals(this.properties, that.properties);
    }

    public int hashCode() {
        return Objects.hash(this.userId, this.properties);
    }
}

