/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm;

import com.atlassian.bitbucket.Product;
import com.atlassian.bitbucket.help.HelpPathService;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.scm.ScmRequest;
import com.atlassian.bitbucket.scm.ScmRequestCheckService;
import com.atlassian.bitbucket.scm.http.HttpScmRequest;
import com.atlassian.bitbucket.throttle.ResourceBusyException;
import com.atlassian.stash.internal.scm.HttpScmRequestExecutor;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import javax.annotation.Nonnull;
import javax.servlet.AsyncContext;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHttpScmRequestExecutor
implements HttpScmRequestExecutor {
    private static final Logger log = LoggerFactory.getLogger(DefaultHttpScmRequestExecutor.class);
    private final boolean allowAsync;
    private final ScmRequestCheckService checkService;
    private final ExecutorService executorService;
    private final HelpPathService helpPathService;
    private final I18nService i18nService;

    public DefaultHttpScmRequestExecutor(ScmRequestCheckService checkService, ExecutorService executorService, HelpPathService helpPathService, I18nService i18nService, boolean allowAsync) {
        this.allowAsync = allowAsync;
        this.checkService = checkService;
        this.executorService = executorService;
        this.helpPathService = helpPathService;
        this.i18nService = i18nService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(@Nonnull HttpServletRequest request, @Nonnull HttpScmRequest scmRequest) throws IOException {
        AsyncContext asyncContext = null;
        if (this.allowAsync && request.isAsyncSupported()) {
            asyncContext = request.startAsync();
            asyncContext.setTimeout(0L);
            try {
                this.queueAsync(scmRequest, asyncContext);
                return;
            }
            catch (RejectedExecutionException e) {
                log.warn("{}: There are too many queued requests; the request will run synchronously instead", (Object)scmRequest.getRepository());
            }
        }
        try {
            this.runSync(scmRequest);
        }
        finally {
            if (asyncContext != null) {
                asyncContext.complete();
            }
        }
    }

    private void queueAsync(HttpScmRequest scmRequest, AsyncContext asyncContext) {
        this.executorService.execute(() -> {
            try {
                this.runSync(scmRequest);
            }
            catch (Exception e) {
                log.warn("{}: Async processing failed", (Object)scmRequest.getRepository(), (Object)e);
            }
            finally {
                asyncContext.complete();
            }
        });
    }

    private void runSync(HttpScmRequest scmRequest) throws IOException {
        if (!this.checkService.checkActionAllowed((ScmRequest)scmRequest)) {
            return;
        }
        try {
            scmRequest.handleRequest();
        }
        catch (ResourceBusyException e) {
            scmRequest.sendError(this.i18nService.getMessage("bitbucket.scm.throttled", new Object[0]), this.i18nService.getMessage("bitbucket.scm.throttled.detail", new Object[]{Product.NAME}));
            log.info(String.format("A %s request was denied due to heavy server load. Please see %s for performance guidelines.", e.getResourceName(), this.helpPathService.getPageUrl("bitbucket.help.scaling")));
        }
    }
}

