/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.johnson.handler.bean;

import com.atlassian.bitbucket.Product;
import com.atlassian.stash.internal.home.HomeDirectoryMigrationException;
import com.atlassian.stash.internal.johnson.AbstractHelpPathProvider;
import com.atlassian.stash.internal.johnson.handler.EventDetails;
import com.atlassian.stash.internal.johnson.handler.bean.BeanFailureHandler;
import com.google.common.base.Throwables;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.BeanCreationException;

public class HomeDirectoryMigrationHandler
extends AbstractHelpPathProvider
implements BeanFailureHandler {
    private static final String UPGRADE_GUIDE_URL = "https://confluence.atlassian.com/x/JAHRJQ";

    public EventDetails handle(@Nonnull BeanCreationException exception) {
        AbstractHelpPathProvider.HelpDetails help = this.getHelp("bitbucket.kb.upgrading.home.directory.manually", "our documentation", UPGRADE_GUIDE_URL);
        StringBuilder message = new StringBuilder("<p>The ").append(Product.NAME).append(" home directory could not be upgraded automatically.<ul><li>");
        Throwable cause = exception.getCause();
        if (cause instanceof HomeDirectoryMigrationException) {
            List validationErrors = ((HomeDirectoryMigrationException)cause).getValidationErrors();
            message.append(StringUtils.join((Iterable)validationErrors, (String)"</li><li>"));
            Throwable rootCause = Throwables.getRootCause((Throwable)cause);
            if (rootCause != null && !rootCause.equals(cause)) {
                message.append(' ').append(rootCause.getLocalizedMessage());
            }
        } else {
            message.append(cause.getLocalizedMessage());
        }
        message.append("</li></ul></p>").append("<p>Please refer to <a href=\"").append(help.getUrl()).append("\">").append(help.getTitle()).append("</a> for more information.</p>");
        return new EventDetails("home-migration-failed", message.toString().replace("\n", "<br/>"), cause);
    }
}

