/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.johnson;

import com.atlassian.johnson.Johnson;
import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.johnson.spring.lifecycle.LifecycleUtils;
import com.atlassian.stash.internal.johnson.JohnsonUtils;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class JohnsonServlet
extends HttpServlet {
    private static final String PAGE_FATAL_ERROR = "/fatal.jsp";
    private static final String PAGE_MAINTENANCE = "/mvc/maintenance";
    private static final String PAGE_STARTUP = "/system/startup";
    private static final String PAGE_SYSTEM_MAINTENANCE = "/mvc/maintenance/lock";
    private static final Map<String, String> LEVELS_TO_PAGES = ImmutableMap.builder().put((Object)"maintenance", (Object)"/mvc/maintenance").put((Object)"system-maintenance", (Object)"/mvc/maintenance/lock").build();

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        JohnsonEventContainer eventContainer = Johnson.getEventContainer((ServletContext)this.getServletContext());
        String highestEventLevel = JohnsonUtils.findHighestEventLevel((JohnsonEventContainer)eventContainer);
        if (highestEventLevel == null) {
            if (LifecycleUtils.isStarting((ServletContext)this.getServletContext())) {
                request.getRequestDispatcher(PAGE_STARTUP).forward((ServletRequest)request, (ServletResponse)response);
            } else {
                response.sendRedirect(JohnsonUtils.getRedirectUrl((HttpServletRequest)request, (String)request.getContextPath()));
            }
        } else if (LEVELS_TO_PAGES.containsKey(highestEventLevel)) {
            request.getRequestDispatcher((String)LEVELS_TO_PAGES.get(highestEventLevel)).forward((ServletRequest)request, (ServletResponse)response);
        } else {
            request.getRequestDispatcher(PAGE_FATAL_ERROR).forward((ServletRequest)request, (ServletResponse)response);
        }
    }
}

