/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.johnson;

import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.johnson.event.ApplicationEventCheck;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevel;
import com.atlassian.johnson.event.EventType;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.servlet.ServletContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaVersionApplicationEventCheck
implements ApplicationEventCheck {
    private static final Logger log = LoggerFactory.getLogger(JavaVersionApplicationEventCheck.class);
    private static final Map<String, String> UNSUPPORTED = ImmutableMap.of((Object)"9$|9\\.\\d+\\.\\d+$", (Object)"Java 9", (Object)"10$|10\\.\\d+\\.\\d+$", (Object)"Java 10", (Object)"11\\.0\\.2", (Object)"Java 11.0.2 (specifically this update version)");

    public void check(@Nonnull JohnsonEventContainer eventContainer, @Nonnull ServletContext context) {
        String version = System.getProperty("java.version");
        if (version == null) {
            return;
        }
        for (String key : UNSUPPORTED.keySet()) {
            if (!Pattern.matches(key, version)) continue;
            this.addError(eventContainer, (String)UNSUPPORTED.get(key) + " is not supported");
            break;
        }
    }

    private void addError(JohnsonEventContainer eventContainer, String message) {
        log.error(message);
        eventContainer.addEvent(new Event(EventType.get((String)"unsupported-java-version"), message, EventLevel.get((String)"fatal")));
    }
}

