/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.hazelcast;

import com.atlassian.stash.internal.hazelcast.HazelcastSessionMode;
import com.hazelcast.web.WebFilter;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class ConfigurableWebFilter
implements Filter {
    private final WebFilter delegate;
    private final boolean enabled;

    public ConfigurableWebFilter(HazelcastSessionMode config, WebFilter delegate) {
        this.enabled = config != HazelcastSessionMode.LOCAL;
        this.delegate = delegate;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        if (this.enabled) {
            this.delegate.init(filterConfig);
        } else {
            filterConfig.getServletContext().setAttribute(WebFilter.class.getName(), (Object)this.delegate);
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.enabled) {
            this.delegate.doFilter(request, response, chain);
        } else {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
        if (this.enabled) {
            this.delegate.destroy();
        }
    }
}

