/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.boot.web;

import com.atlassian.bitbucket.Product;
import com.atlassian.bitbucket.internal.boot.web.CommonConnectorProperties;
import com.google.common.primitives.Ints;
import java.io.FileNotFoundException;
import java.net.InetAddress;
import java.util.function.Consumer;
import org.apache.catalina.connector.Connector;
import org.apache.coyote.AbstractProtocol;
import org.apache.coyote.ProtocolHandler;
import org.apache.coyote.ajp.AbstractAjpProtocol;
import org.apache.coyote.http11.AbstractHttp11JsseProtocol;
import org.apache.coyote.http11.AbstractHttp11Protocol;
import org.apache.tomcat.util.net.SSLHostConfig;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.web.server.Compression;
import org.springframework.boot.web.server.Ssl;
import org.springframework.boot.web.server.WebServerException;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.unit.DataSize;

/*
 * Exception performing whole class analysis ignored.
 */
public class ConnectorProperties
extends CommonConnectorProperties {
    private final int connectorNumber;
    @NestedConfigurationProperty
    private final Compression compression;
    @NestedConfigurationProperty
    private final Ssl ssl;
    private InetAddress address;
    private Integer connectionTimeout;
    private DataSize maxHttpHeaderSize;
    private DataSize maxHttpPostSize;
    private Integer port;

    public ConnectorProperties(int connectorNumber) {
        super("server.additional-connector." + connectorNumber);
        this.connectorNumber = connectorNumber;
        this.compression = new Compression();
        this.ssl = new Ssl();
        this.ssl.setEnabled(false);
    }

    public void customize(Connector connector) {
        AbstractProtocol protocol;
        super.customize(connector);
        connector.setPort(this.port.intValue());
        ConnectorProperties.applyIfPositive((DataSize)this.maxHttpPostSize, arg_0 -> ((Connector)connector).setMaxPostSize(arg_0));
        ProtocolHandler protocolHandler = connector.getProtocolHandler();
        if (protocolHandler instanceof AbstractProtocol) {
            protocol = (AbstractProtocol)protocolHandler;
            if (this.address != null) {
                protocol.setAddress(this.address);
            }
            if (this.connectionTimeout != null) {
                protocol.setConnectionTimeout(this.connectionTimeout.intValue());
            }
        }
        if (protocolHandler instanceof AbstractHttp11Protocol) {
            protocol = (AbstractHttp11Protocol)protocolHandler;
            if (this.compression.getEnabled()) {
                this.configureCompression((AbstractHttp11Protocol)protocol);
            }
            ConnectorProperties.applyIfPositive((DataSize)this.maxHttpHeaderSize, arg_0 -> ((AbstractHttp11Protocol)protocol).setMaxHttpHeaderSize(arg_0));
        }
        if (this.ssl.isEnabled()) {
            if (protocolHandler instanceof AbstractHttp11JsseProtocol) {
                connector.setScheme("https");
                connector.setSecure(true);
                protocol = (AbstractHttp11JsseProtocol)protocolHandler;
                this.configureSsl((AbstractHttp11JsseProtocol)protocol);
                this.configureSslKeyStore((AbstractHttp11JsseProtocol)protocol);
                this.configureSslTrustStore((AbstractHttp11JsseProtocol)protocol);
            } else if (protocolHandler instanceof AbstractAjpProtocol) {
                throw new IllegalStateException("SSL cannot be enabled on AJP/1.3 connectors. Remove " + this.getPrefix() + ".ssl.enabled=true from " + "bitbucket.properties" + " and restart " + Product.NAME);
            }
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("AdditionalConnector[").append(this.connectorNumber).append(": ").append(this.port);
        if (this.isAjp()) {
            builder.append(" (AJP/1.3)");
        } else {
            builder.append(" (HTTP").append(this.ssl.isEnabled() ? "S" : "").append("/1.1)");
        }
        return builder.append("]").toString();
    }

    private static void applyIfPositive(DataSize size, Consumer<Integer> target) {
        PropertyMapper propertyMapper = PropertyMapper.get();
        propertyMapper.from((Object)size).whenNonNull().asInt(DataSize::toBytes).when(value -> value > 0).to(target);
    }

    private void configureCompression(AbstractHttp11Protocol<?> protocol) {
        protocol.setCompressibleMimeType(StringUtils.arrayToCommaDelimitedString((Object[])this.compression.getMimeTypes()));
        protocol.setCompression("on");
        protocol.setCompressionMinSize(Ints.saturatedCast((long)this.compression.getMinResponseSize().toBytes()));
        Object[] excludedUserAgents = this.compression.getExcludedUserAgents();
        if (excludedUserAgents != null && excludedUserAgents.length > 0) {
            protocol.setNoCompressionUserAgents(StringUtils.arrayToCommaDelimitedString((Object[])excludedUserAgents));
        }
    }

    private void configureSsl(AbstractHttp11JsseProtocol<?> protocol) {
        protocol.setSSLEnabled(true);
        protocol.setCiphers(org.apache.commons.lang3.StringUtils.trimToNull((String)StringUtils.arrayToCommaDelimitedString((Object[])this.ssl.getCiphers())));
        protocol.setKeyAlias(this.ssl.getKeyAlias());
        protocol.setKeyPass(this.ssl.getKeyPassword());
        protocol.setSslProtocol(this.ssl.getProtocol());
        Ssl.ClientAuth clientAuth = this.ssl.getClientAuth();
        if (clientAuth == Ssl.ClientAuth.NEED) {
            protocol.setClientAuth("true");
        } else if (clientAuth == Ssl.ClientAuth.WANT) {
            protocol.setClientAuth("want");
        }
        String enabledProtocols = StringUtils.arrayToCommaDelimitedString((Object[])this.ssl.getEnabledProtocols());
        if (!enabledProtocols.isEmpty()) {
            for (SSLHostConfig config : protocol.findSslHostConfigs()) {
                config.setProtocols(enabledProtocols);
            }
        }
    }

    private void configureSslKeyStore(AbstractHttp11JsseProtocol<?> protocol) {
        try {
            protocol.setKeystoreFile(ResourceUtils.getURL((String)this.ssl.getKeyStore()).toString());
        }
        catch (FileNotFoundException e) {
            throw new WebServerException("\"" + this.getPrefix() + ".ssl.key-store=" + this.ssl.getKeyStore() + "\" references a path which does not exist", (Throwable)e);
        }
        protocol.setKeystorePass(this.ssl.getKeyStorePassword());
        protocol.setKeystoreProvider(this.ssl.getKeyStoreProvider());
        protocol.setKeystoreType(this.ssl.getKeyStoreType());
    }

    private void configureSslTrustStore(AbstractHttp11JsseProtocol<?> protocol) {
        if (this.ssl.getTrustStore() != null) {
            try {
                protocol.setTruststoreFile(ResourceUtils.getURL((String)this.ssl.getTrustStore()).toString());
            }
            catch (FileNotFoundException e) {
                throw new WebServerException("\"" + this.getPrefix() + ".ssl.trust-store=" + this.ssl.getTrustStore() + "\" references a path which does not exist", (Throwable)e);
            }
            protocol.setTruststorePass(this.ssl.getTrustStorePassword());
            protocol.setTruststoreProvider(this.ssl.getTrustStoreProvider());
            protocol.setTruststoreType(this.ssl.getTrustStoreType());
        }
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public Compression getCompression() {
        return this.compression;
    }

    public Integer getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public DataSize getMaxHttpHeaderSize() {
        return this.maxHttpHeaderSize;
    }

    public DataSize getMaxHttpPostSize() {
        return this.maxHttpPostSize;
    }

    public Integer getPort() {
        return this.port;
    }

    public Ssl getSsl() {
        return this.ssl;
    }

    public void setAddress(InetAddress address) {
        this.address = address;
    }

    public void setConnectionTimeout(Integer connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setMaxHttpHeaderSize(DataSize maxHttpHeaderSize) {
        this.maxHttpHeaderSize = maxHttpHeaderSize;
    }

    public void setMaxHttpPostSize(DataSize maxHttpPostSize) {
        this.maxHttpPostSize = maxHttpPostSize;
    }

    public void setPort(Integer port) {
        this.port = port;
    }
}

