'use strict';

require(['aui', 'jquery', 'bitbucket/util/navbuilder', 'bitbucket/internal/feature/commit/request-commit'], function (AJS, $, nav, requestCommit) {
    var truncateCommitMessage = function truncateCommitMessage(commitMessage) {
        //Truncate long commit messages to ~750 characters (break on the first whitespace character AFTER the 750th character)
        var truncated = commitMessage.substring(0, commitMessage.substring(750).search(/\s/) + 750);
        return truncated.length < commitMessage.length ? truncated + '…' : truncated;
    };

    var refreshTipsy = function refreshTipsy($el) {
        if ($el.data('tipsy').hoverState === 'in') {
            $el.tipsy('hide');
            $el.tipsy('show');
        }
    };

    $(function () {
        $('a.commitid:not(.no-preview), .commit-preview-trigger').tipsy({
            live: true,
            opacity: 0.98,
            gravity: function gravity() {
                return $(this).attr('data-commit-preview-gravity') || $.fn.tipsy.autoNS.call(this) + $.fn.tipsy.autoWE.call(this);
            },
            className: 'commit-preview-tipsy',
            title: function title() {
                var $this = $(this);
                var commitId = $this.attr('data-commitid') || $this.text();
                var commitMessage = $this.attr('data-commit-message');
                if (commitMessage) {
                    return truncateCommitMessage(commitMessage);
                }

                var paramsRegex = /.*?\/(projects|users)\/([^\/]+)\/repos\/([^\/]+)\//;
                var matches = nav.parse($this.attr('href')).path().match(paramsRegex);
                requestCommit({
                    commitId: commitId,
                    project: matches && (matches[1] === 'users' ? '~' : '') + matches[2],
                    repo: matches && matches[3],
                    statusCode: {
                        '404': false,
                        '*': false // this should never cause a redirect or an error dialog or any other default handling.
                    }
                }).then(function (commit) {
                    $this.attr('data-commit-message', commit.message ? truncateCommitMessage(commit.message) : AJS.I18n.getText('bitbucket.web.commit.preview.message.empty'));
                    refreshTipsy($this);
                }, function () {
                    $this.attr('data-commit-message', AJS.I18n.getText('bitbucket.web.commit.preview.request.failed'));
                    refreshTipsy($this);
                });

                return AJS.I18n.getText('bitbucket.web.commit.preview.loading');
            }
        });
    });
});