define('bitbucket/internal/page/repository/empty/empty-repository', ['module', 'exports', 'aui', 'jquery', 'bitbucket/util/state', 'bitbucket/internal/util/ajax', 'bitbucket/internal/util/events'], function (module, exports, _aui, _jquery, _state, _ajax, _events) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _aui2 = babelHelpers.interopRequireDefault(_aui);

    var _jquery2 = babelHelpers.interopRequireDefault(_jquery);

    var _state2 = babelHelpers.interopRequireDefault(_state);

    var _ajax2 = babelHelpers.interopRequireDefault(_ajax);

    var _events2 = babelHelpers.interopRequireDefault(_events);

    function updateInstructions(module, cloneUrl) {
        (0, _jquery2.default)('#empty-repository-instructions').html(bitbucket.internal.page.emptyRepositoryInstructions({
            repository: _state2.default.getRepository(),
            cloneUrl: cloneUrl,
            currentUser: _state2.default.getCurrentUser()
        }));
    }

    _events2.default.on('bitbucket.internal.feature.repository.clone.protocol.initial', updateInstructions);
    _events2.default.on('bitbucket.internal.feature.repository.clone.protocol.changed', updateInstructions);

    function onReady(notInitialised) {
        if ((0, _jquery2.default)('#empty-repository-instructions:empty').length) {
            updateInstructions(null, _state2.default.getRepository().cloneUrl);
        }

        if (notInitialised) {
            var browse = '/browse';
            var i = window.location.href.lastIndexOf(browse);
            var pollUrl = i === -1 ? window.location.href : window.location.href.substr(0, i);
            var $initialisingContainer = (0, _jquery2.default)('<div id="initialising" />');
            var $initialisingMessage = (0, _jquery2.default)('<h2></h2>');
            var $page = (0, _jquery2.default)('#content .content-body');
            $initialisingMessage.text(_aui2.default.I18n.getText('bitbucket.web.repository.initialising'));

            $page.css('opacity', 0.2);

            $initialisingMessage.appendTo($initialisingContainer);
            $initialisingContainer.appendTo($page.parent());
            $initialisingContainer.spin('large');
            _ajax2.default.poll({
                url: pollUrl,
                tick: function tick(data) {
                    var state = data && data.state;
                    if (state === 'AVAILABLE') {
                        return true;
                    } else if (state === 'INITIALISATION_FAILED') {
                        return false;
                    }
                    return undefined;
                }
            }).always(function () {
                $initialisingContainer.spinStop();
                $initialisingContainer.remove();
                $page.fadeTo('fast', 1);
            }).fail(function (xhr, statusText, something, repo) {
                $page.empty().css('padding', '16px');
                if (xhr.status === 200) {
                    (0, _jquery2.default)(aui.message.error({
                        content: _aui2.default.escapeHtml(repo.statusMessage)
                    })).appendTo($page);
                }
            });
        }
    }

    exports.default = {
        onReady: onReady
    };
    module.exports = exports['default'];
});