define('bitbucket/internal/feature/pull-request/list-dialog/pull-request-list-dialog', ['module', 'exports', 'aui', 'jquery', 'lodash', 'bitbucket/util/navbuilder', 'bitbucket/internal/feature/pull-request/table/pull-request-table', 'bitbucket/internal/model/page-state', 'bitbucket/internal/util/ajax', 'bitbucket/internal/util/events', 'bitbucket/internal/widget/avatar-list/avatar-list'], function (module, exports, _aui, _jquery, _lodash, _navbuilder, _pullRequestTable, _pageState, _ajax, _events, _avatarList) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _aui2 = babelHelpers.interopRequireDefault(_aui);

    var _jquery2 = babelHelpers.interopRequireDefault(_jquery);

    var _lodash2 = babelHelpers.interopRequireDefault(_lodash);

    var _navbuilder2 = babelHelpers.interopRequireDefault(_navbuilder);

    var _pullRequestTable2 = babelHelpers.interopRequireDefault(_pullRequestTable);

    var _pageState2 = babelHelpers.interopRequireDefault(_pageState);

    var _ajax2 = babelHelpers.interopRequireDefault(_ajax);

    var _events2 = babelHelpers.interopRequireDefault(_events);

    var _avatarList2 = babelHelpers.interopRequireDefault(_avatarList);

    var dialog;
    var pullRequestTable;

    function getPullRequestsUrlBuilder() {
        return _navbuilder2.default.rest().currentRepo().allPullRequests();
    }

    function bindKeyboardShortcuts() {
        pullRequestTable.initShortcuts();

        _events2.default.on('bitbucket.internal.widget.keyboard-shortcuts.register-contexts', function (keyboardShortcuts) {
            keyboardShortcuts.enableContext('pull-request-list');
        });

        _events2.default.on('bitbucket.internal.keyboard.shortcuts.requestMoveToNextHandler', pullRequestTable.bindMoveToNextHandler);
        _events2.default.on('bitbucket.internal.keyboard.shortcuts.requestMoveToPreviousHandler', pullRequestTable.bindMoveToPreviousHandler);
        _events2.default.on('bitbucket.internal.keyboard.shortcuts.requestOpenItemHandler', pullRequestTable.bindOpenItemHandler);
        _events2.default.on('bitbucket.internal.keyboard.shortcuts.pullrequest.requestHighlightAssignedHandler', pullRequestTable.bindHighlightAssignedHandler);
    }

    function createPullRequestListDialog(content, direction, sourceBranch, state, order) {
        var dialog = new _aui2.default.Dialog({
            width: 980,
            height: 480,
            id: 'pull-request-list-dialog',
            closeOnOutsideClick: true
        }).addHeader(_aui2.default.I18n.getText('bitbucket.web.pullrequest.listdialog.header'));

        pullRequestTable = new _pullRequestTable2.default(state, order, getPullRequestsUrlBuilder, {
            direction: direction,
            source: sourceBranch
        });

        dialog.addPanel('', content);
        dialog.addCancel(_aui2.default.I18n.getText('bitbucket.web.button.close'), _lodash2.default.bind(dialog.hide, dialog));

        return dialog;
    }

    function getInjectedData() {
        return {
            principal: _pageState2.default.getCurrentUser().toJSON()
        };
    }

    function updateContent(pullRequests) {
        dialog.getCurrentPanel().html(bitbucket.internal.feature.pullRequest.pullRequestTable({
            pullRequestPage: pullRequests,
            showStatus: 'true',
            hideAuthorName: 'true'
        }, null, getInjectedData()));

        pullRequestTable.init();
        _avatarList2.default.init();

        bindKeyboardShortcuts();

        return dialog;
    }

    function removeDialog() {
        (0, _jquery2.default)(document).off('hideLayer', removeDialog);
        if (dialog) {
            dialog.remove();
            dialog = null;
        }
        if (pullRequestTable) {
            pullRequestTable = null;
        }
    }

    function cancelDialog(dialog) {
        if (dialog) {
            // the event handler for 'hideLayer' will automatically remove the dialog from the DOM
            dialog.hide();
        }
    }

    function fetchResults(dialog) {
        return _ajax2.default.rest({
            url: pullRequestTable.buildUrl(0, 25)
        }).fail(function () {
            // cancel the dialog, since the default error handling from ajax.rest() will
            // also show an error dialog (or redirect to the login page);
            // this avoids having the error dialog showing up on top of the pull request dialog.
            cancelDialog(dialog);
        }).done(function (page) {
            updateContent(page);
            dialog.updateHeight();
        });
    }

    exports.default = {
        /**
         * Pops up a dialog with a list of pull requests fetched from the server matching the supplied parameters.
         *
         * @param {String} direction the directions of the pull requests you want to display used with sourceBranch (optional)
         * @param {String} sourceBranch the branch to show pull requests for (optional)
         * @param {String} state only show pull requests in this state (defaults to open)
         * @param {String} order the order to show the pull requests in either 'newest' or 'oldest' first
         * */
        showFor: function showFor(direction, sourceBranch, state, order) {
            removeDialog();
            (0, _jquery2.default)(document).on('hideLayer', removeDialog);

            var $spinner = (0, _jquery2.default)('<div class="spinner"></div>');
            dialog = createPullRequestListDialog($spinner, direction, sourceBranch, state, order);
            dialog.show();

            $spinner.show().spin('large');

            fetchResults(dialog).always(function () {
                $spinner.spinStop().remove();
            });
        }
    };
    module.exports = exports['default'];
});