define('bitbucket/internal/feature/project/project-table/project-table', ['module', 'exports', 'jquery', 'bitbucket/util/navbuilder', 'bitbucket/internal/widget/paged-table/paged-table'], function (module, exports, _jquery, _navbuilder, _pagedTable) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _jquery2 = babelHelpers.interopRequireDefault(_jquery);

    var _navbuilder2 = babelHelpers.interopRequireDefault(_navbuilder);

    var _pagedTable2 = babelHelpers.interopRequireDefault(_pagedTable);

    function ProjectTable(options) {
        options = _jquery2.default.extend({}, ProjectTable.defaults, options);
        _pagedTable2.default.call(this, options);
    }

    ProjectTable.defaults = {
        paginationContext: 'project-table'
    };

    _jquery2.default.extend(ProjectTable.prototype, _pagedTable2.default.prototype);

    ProjectTable.prototype.buildUrl = function (start, limit) {
        return _navbuilder2.default.allProjects().withParams({
            start: start,
            limit: limit,
            avatarSize: bitbucket.internal.widget.avatarSizeInPx({
                size: 'large'
            })
        }).build();
    };

    ProjectTable.prototype.handleNewRows = function (projectPage, attachmentMethod) {
        this.$table.find('tbody')[attachmentMethod](bitbucket.internal.feature.project.projectRows({
            projects: projectPage.values
        }));
    };

    exports.default = ProjectTable;
    module.exports = exports['default'];
});