define('bitbucket/internal/feature/dashboard/reducers/ui/pull-request-suggestions', ['module', 'exports', 'lodash', 'bitbucket/internal/bbui/utils/create-reducer', 'bitbucket/internal/feature/dashboard/actions'], function (module, exports, _lodash, _createReducer2, _actions) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _createReducer3 = babelHelpers.interopRequireDefault(_createReducer2);

    var _createReducer;

    var loadPullRequestSuggestions = function loadPullRequestSuggestions(state) {
        return babelHelpers.extends({}, state, { loading: true });
    };
    var loadPullRequestSuggestionsComplete = function loadPullRequestSuggestionsComplete(state) {
        return babelHelpers.extends({}, state, {
            loading: false
        });
    };

    var makeUpdater = function makeUpdater(update) {
        return function (state, _ref) {
            var meta = _ref.meta;
            return (0, _lodash.merge)({}, state, {
                suggestions: babelHelpers.defineProperty({}, meta.suggestionId, update)
            });
        };
    };

    var loadPullRequestSuggestionCommits = makeUpdater({ loading: true });
    var loadPullRequestSuggestionCommitsSuccess = makeUpdater({ loading: false });
    var loadPullRequestSuggestionCommitsFailure = makeUpdater({
        loading: false,
        open: false
    });
    var openPullRequestSuggestionCommits = makeUpdater({ open: true });
    var closePullRequestSuggestionCommits = makeUpdater({ open: false });

    exports.default = (0, _createReducer3.default)({}, (_createReducer = {}, babelHelpers.defineProperty(_createReducer, _actions.LOAD_PULL_REQUEST_SUGGESTIONS, loadPullRequestSuggestions), babelHelpers.defineProperty(_createReducer, _actions.LOAD_PULL_REQUEST_SUGGESTIONS_SUCCESS, loadPullRequestSuggestionsComplete), babelHelpers.defineProperty(_createReducer, _actions.LOAD_PULL_REQUEST_SUGGESTIONS_FAILURE, loadPullRequestSuggestionsComplete), babelHelpers.defineProperty(_createReducer, _actions.LOAD_PULL_REQUEST_SUGGESTION_COMMITS, loadPullRequestSuggestionCommits), babelHelpers.defineProperty(_createReducer, _actions.LOAD_PULL_REQUEST_SUGGESTION_COMMITS_SUCCESS, loadPullRequestSuggestionCommitsSuccess), babelHelpers.defineProperty(_createReducer, _actions.LOAD_PULL_REQUEST_SUGGESTION_COMMITS_FAILURE, loadPullRequestSuggestionCommitsFailure), babelHelpers.defineProperty(_createReducer, _actions.OPEN_PULL_REQUEST_SUGGESTION_COMMITS, openPullRequestSuggestionCommits), babelHelpers.defineProperty(_createReducer, _actions.CLOSE_PULL_REQUEST_SUGGESTION_COMMITS, closePullRequestSuggestionCommits), _createReducer));
    module.exports = exports['default'];
});