define('bitbucket/internal/feature/dashboard/components/repository-search', ['exports', 'react', 'react-dom', 'react-redux', 'bitbucket/util/events', 'bitbucket/internal/impl/web-fragments', 'bitbucket/internal/util/shortcuts', '../action-creators/load-repositories', '../repository-type'], function (exports, _react, _reactDom, _reactRedux, _events, _webFragments, _shortcuts, _loadRepositories, _repositoryType) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.RepositorySearch = undefined;

    var _react2 = babelHelpers.interopRequireDefault(_react);

    var _events2 = babelHelpers.interopRequireDefault(_events);

    var _webFragments2 = babelHelpers.interopRequireDefault(_webFragments);

    var _shortcuts2 = babelHelpers.interopRequireDefault(_shortcuts);

    var SEARCH_LOCATION = 'internal.bitbucket.dashboard.repository.search';

    var RepositorySearch = exports.RepositorySearch = function (_Component) {
        babelHelpers.inherits(RepositorySearch, _Component);

        function RepositorySearch(props) {
            babelHelpers.classCallCheck(this, RepositorySearch);

            var _this = babelHelpers.possibleConstructorReturn(this, (RepositorySearch.__proto__ || Object.getPrototypeOf(RepositorySearch)).call(this, props));

            _this.state = {
                Search: null
            };
            return _this;
        }

        babelHelpers.createClass(RepositorySearch, [{
            key: 'componentWillMount',
            value: function componentWillMount() {
                var _this2 = this;

                var panels = _webFragments2.default.getWebPanels(SEARCH_LOCATION);
                if (panels.length > 0) {
                    this.setState({
                        // getWebPanels in the SPI version of webFragments (as opposed to WebFragments global) returns the result
                        // of calling the view function as .html, but really it's just whatever the "view" in the client-web-panel
                        // returns, which in this case is a React component
                        Search: panels[0].html
                    });
                }

                _shortcuts2.default.bind('dashboardRepositories', function () {
                    return _this2.focusRepositorySearch();
                });
            }
        }, {
            key: 'onSearchStart',
            value: function onSearchStart(query) {
                this.props.dispatch((0, _loadRepositories.loadRepositories)({ repoType: _repositoryType.SEARCH, query: query }));
            }
        }, {
            key: 'onSearchEnd',
            value: function onSearchEnd(query) {
                // TODO ???
            }
        }, {
            key: 'onSearchClear',
            value: function onSearchClear() {
                this.props.dispatch((0, _loadRepositories.clearRepositories)({ repoType: _repositoryType.SEARCH }));
            }
        }, {
            key: 'onSearchError',
            value: function onSearchError() {
                this.props.dispatch((0, _loadRepositories.loadRepositoriesFailure)({ repoType: _repositoryType.SEARCH }));
            }
        }, {
            key: 'onSearchResults',
            value: function onSearchResults(query, page, nextSearch) {
                if (page.start === 0) {
                    // analytics for search results loaded
                    _events2.default.trigger('bitbucket.internal.ui.dashboard.repository-list.search.results.loaded', null, {
                        queryLength: query.length
                    });
                }
                this.props.dispatch((0, _loadRepositories.loadRepositoriesSuccess)(page, { repoType: _repositoryType.SEARCH, nextSearch: nextSearch, query: query }));
            }

            /**
             * Call a given callback if the event target is an input (from which we infer that it is the search field input)
             *
             * @param {DOMEvent} event
             * @param {Function} cb - The callback to call if the filter passes
             */

        }, {
            key: 'onSearchFieldEvent',
            value: function onSearchFieldEvent(event, cb) {
                if (event.target.nodeName === 'INPUT') {
                    cb(event);
                }
            }
        }, {
            key: 'focusRepositorySearch',
            value: function focusRepositorySearch() {
                var input = (0, _reactDom.findDOMNode)(this).querySelector('input.search');
                if (input) {
                    input.focus();
                }
            }
        }, {
            key: 'render',
            value: function render() {
                var _this3 = this;

                var Search = this.state.Search;

                return Search ? _react2.default.createElement(
                    'div',
                    { // the wrapper div is to catch any DOM events that bubble up from the Search plugin
                        onKeyDown: function onKeyDown(e) {
                            return _this3.onSearchFieldEvent(e, _this3.props.onKeyDown);
                        },
                        onBlur: function onBlur(e) {
                            return _this3.onSearchFieldEvent(e, _this3.props.onBlur);
                        },
                        onFocus: function onFocus(e) {
                            return _this3.onSearchFieldEvent(e, _this3.props.onFocus);
                        }
                    },
                    _react2.default.createElement(Search, {
                        onSearchStart: function onSearchStart(query) {
                            return _this3.onSearchStart(query);
                        },
                        onSearchEnd: function onSearchEnd(query) {
                            return _this3.onSearchEnd(query);
                        },
                        onSearchResults: function onSearchResults(query, page, nextSearch) {
                            return _this3.onSearchResults(query, page, nextSearch);
                        },
                        onSearchError: function onSearchError() {
                            return _this3.onSearchError();
                        },
                        onSearchClear: function onSearchClear() {
                            return _this3.onSearchClear();
                        },
                        pageSize: 25 /* FIXME pass a default page size */
                    })
                ) : null;
            }
        }]);
        return RepositorySearch;
    }(_react.Component);

    exports.default = (0, _reactRedux.connect)()(RepositorySearch);
});